<!--
  ~ Licensed to the Apache Software Foundation (ASF) under one or more
  ~ contributor license agreements.  See the NOTICE file distributed with
  ~ this work for additional information regarding copyright ownership.
  ~ The ASF licenses this file to You under the Apache License, Version 2.0
  ~ (the "License"); you may not use this file except in compliance with
  ~ the License.  You may obtain a copy of the License at
  ~
  ~      http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS,
  ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  ~ See the License for the specific language governing permissions and
  ~ limitations under the License.
  -->

Unomi tracker: Versioning and release
============

Branches
-------
Current repository is using Trunk based development.

- `main`: Used for latest currently develop version
- `1_x`: Used for maintenance branches of previous versions
- `UNOMI-XXX`: feature or bug fix branches used to create pull request targeting the `main` branch

Npm account
-------
- Create an account on NpmJS registry: https://www.npmjs.com/
- Ask on Apache Unomi dev mailing list (dev@unomi.apache.org) to be added as a maintainer for the package to be able to push versions
- Login locally: `npm login` and your credentials

Push a new version
-------
- Bump version in the `main` branch: `1.0.0` -> `1.1.0` or for beta version `1.0.0-beta.0` -> `1.0.0-beta.1`, run:
  - `npm version 3.1.0-beta.1`: to update `package.json` and create a git tag in one go (see https://docs.npmjs.com/cli/version).
  - `git push origin main`: push the version update
  - `git push origin 3.1.0-beta.1`: push the git tag
- Run checks:
  - `yarn lint`: ensure linter checks are passing
  - `yarn test`: ensure tests are passing
  - `yarn build`: ensure build is passing
- Publish on npm the package, run:
  - in case of normal version: `npm publish`
  - in case of beta version: `npm publish --tag beta`
- Create the release on GitHub for this tag (in case version is not beta).