/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model.elements;

import java.util.Arrays;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.events.WelcomeFileEventData;
import org.ops4j.pax.web.service.spi.whiteboard.WhiteboardWebContainerView;
import org.ops4j.pax.web.service.whiteboard.WelcomeFileMapping;

public class WelcomeFileModel
extends ElementModel<WelcomeFileMapping, WelcomeFileEventData> {
    private final String[] welcomeFiles;
    private final boolean redirect;

    public WelcomeFileModel(String[] welcomeFiles, boolean redirect) {
        this.welcomeFiles = welcomeFiles != null ? Arrays.copyOf(welcomeFiles, welcomeFiles.length) : new String[0];
        this.redirect = redirect;
    }

    @Override
    public void register(WhiteboardWebContainerView view) {
        view.registerWelcomeFiles(this);
    }

    @Override
    public void unregister(WhiteboardWebContainerView view) {
        view.unregisterWelcomeFiles(this);
    }

    @Override
    public WelcomeFileEventData asEventData() {
        WelcomeFileEventData welcomeFileEventData = new WelcomeFileEventData(this.welcomeFiles, this.redirect);
        this.setCommonEventProperties(welcomeFileEventData);
        return welcomeFileEventData;
    }

    public String[] getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    @Override
    public String toString() {
        return "WelcomeFileModel{id=" + this.getId() + ",redirect='" + this.redirect + "'" + (this.welcomeFiles == null ? "" : ",welcomeFiles=" + Arrays.toString(this.welcomeFiles)) + ",contexts=" + this.contextModels + "}";
    }

    @Override
    public Boolean performValidation() {
        for (String wf : this.welcomeFiles) {
            if (wf != null && !"".equals(wf.trim()) && !wf.startsWith("/") && !wf.endsWith("/")) continue;
            throw new IllegalArgumentException("Welcome file \"" + wf + "\" should not be empty and should not start/end with \"/\" character.");
        }
        return Boolean.TRUE;
    }
}

