/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.querybuilders.core;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilderDispatcher;

public class SourceEventPropertyConditionESQueryBuilder
implements ConditionESQueryBuilder {
    private void appendFilterIfPropExist(List<Query> queries, Condition condition, String prop) {
        Object parameter = condition.getParameter(prop);
        if (parameter != null && !"".equals(parameter)) {
            queries.add(Query.of(q -> q.term(t -> t.field("source." + prop).value(v -> v.stringValue((String)parameter)))));
        }
    }

    @Override
    public Query buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (String prop : new String[]{"id", "path", "scope", "type"}) {
            this.appendFilterIfPropExist(queries, condition, prop);
        }
        if (queries.isEmpty()) {
            return null;
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        for (Query queryBuilder : queries) {
            boolQueryBuilder.must(queryBuilder, new Query[0]);
        }
        return Query.of(q -> q.bool(boolQueryBuilder.build()));
    }
}

