/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi.config;

import java.util.Dictionary;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class ConfigurationUpdateHelper {
    public static void processConfigurationUpdates(Dictionary<String, ?> properties, Logger logger, String serviceName, Map<String, PropertyMapping> propertyMappings) {
        if (properties == null) {
            return;
        }
        logger.info("{} configuration updated, applying changes without restart", (Object)serviceName);
        try {
            for (Map.Entry<String, PropertyMapping> entry : propertyMappings.entrySet()) {
                String propertyName = entry.getKey();
                PropertyMapping mapping = entry.getValue();
                Object value = properties.get(propertyName);
                if (value == null) continue;
                try {
                    mapping.apply(value, logger);
                    logger.debug("Updated {} to: {}", (Object)propertyName, value);
                }
                catch (Exception e) {
                    logger.warn("Error setting property {}: {}", (Object)propertyName, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("Error applying configuration updates", (Throwable)e);
        }
    }

    public static PropertyMapping booleanProperty(Consumer<Boolean> setter) {
        return (value, logger) -> {
            boolean boolValue = Boolean.parseBoolean(value.toString());
            setter.accept(boolValue);
        };
    }

    public static PropertyMapping stringProperty(Consumer<String> setter) {
        return (value, logger) -> {
            String stringValue = value.toString();
            setter.accept(stringValue);
        };
    }

    public static PropertyMapping integerProperty(Consumer<Integer> setter) {
        return (value, logger) -> {
            int intValue = Integer.parseInt(value.toString());
            setter.accept(intValue);
        };
    }

    public static PropertyMapping longProperty(Consumer<Long> setter) {
        return (value, logger) -> {
            long longValue = Long.parseLong(value.toString());
            setter.accept(longValue);
        };
    }

    public static PropertyMapping customProperty(PropertyProcessor processor) {
        return processor::process;
    }

    @FunctionalInterface
    public static interface PropertyMapping {
        public void apply(Object var1, Logger var2) throws Exception;
    }

    @FunctionalInterface
    public static interface PropertyProcessor {
        public void process(Object var1, Logger var2) throws Exception;
    }
}

