/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast.factory;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.karaf.cellar.core.utils.CombinedClassLoader;
import org.apache.karaf.cellar.hazelcast.factory.HazelcastConfigurationManager;
import org.osgi.framework.BundleContext;

public class HazelcastServiceFactory {
    private BundleContext bundleContext;
    private CombinedClassLoader combinedClassLoader;
    private HazelcastConfigurationManager configurationManager;
    private CountDownLatch initializationLatch = new CountDownLatch(1);
    private CountDownLatch instanceLatch = new CountDownLatch(1);
    private HazelcastInstance instance;

    public void init() {
        if (this.combinedClassLoader != null) {
            this.combinedClassLoader.addBundle(this.bundleContext.getBundle());
        }
        this.initializationLatch.countDown();
    }

    public void destroy() {
        if (this.instance != null) {
            this.instance.getLifecycleService().shutdown();
        }
    }

    public void update(Map properties) throws InterruptedException {
        if (this.configurationManager.isUpdated(properties) && this.instance != null) {
            HazelcastConfigurationManager.LOGGER.info("Updating the member list to: {}", this.configurationManager.getDiscoveredMemberSet());
            this.instance.getConfig().getNetworkConfig().getJoin().getTcpIpConfig().setMembers(new LinkedList<String>(this.configurationManager.getDiscoveredMemberSet()));
        }
    }

    public HazelcastInstance getInstance() throws InterruptedException {
        if (this.instance == null) {
            this.initializationLatch.await();
            this.instance = this.buildInstance();
            this.instanceLatch.countDown();
        }
        return this.instance;
    }

    private HazelcastInstance buildInstance() {
        if (this.combinedClassLoader != null) {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.combinedClassLoader);
        }
        return Hazelcast.newHazelcastInstance((Config)this.configurationManager.getHazelcastConfig());
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public CombinedClassLoader getCombinedClassLoader() {
        return this.combinedClassLoader;
    }

    public void setCombinedClassLoader(CombinedClassLoader combinedClassLoader) {
        this.combinedClassLoader = combinedClassLoader;
    }

    public void setConfigurationManager(HazelcastConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

