/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.messages;

import java.nio.ByteBuffer;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.MessageHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.eclipse.jetty.websocket.jsr356.DecoderFactory;
import org.eclipse.jetty.websocket.jsr356.MessageHandlerWrapper;

public class BinaryWholeMessage
extends SimpleBinaryMessage {
    private final MessageHandlerWrapper msgWrapper;
    private final MessageHandler.Whole<Object> wholeHandler;

    public BinaryWholeMessage(EventDriver onEvent, MessageHandlerWrapper wrapper) {
        super(onEvent);
        this.msgWrapper = wrapper;
        this.wholeHandler = (MessageHandler.Whole)wrapper.getHandler();
    }

    public void messageComplete() {
        ByteBuffer msg;
        this.finished = true;
        byte[] data = this.out == null ? new byte[]{} : this.out.toByteArray();
        DecoderFactory.Wrapper decoder = this.msgWrapper.getDecoder();
        Decoder.Binary binaryDecoder = (Decoder.Binary)decoder.getDecoder();
        if (binaryDecoder.willDecode((msg = BufferUtil.toBuffer((byte[])data)).slice())) {
            try {
                Object obj = binaryDecoder.decode(msg);
                this.wholeHandler.onMessage(obj);
            }
            catch (DecodeException e) {
                throw new WebSocketException("Unable to decode binary data", (Throwable)e);
            }
        }
    }
}

