/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.EventsCollectorRequest;
import org.apache.unomi.rest.exception.InvalidRequestException;
import org.apache.unomi.schema.api.SchemaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsCollectorRequestDeserializer
extends StdDeserializer<EventsCollectorRequest> {
    private static final Logger logger = LoggerFactory.getLogger(EventsCollectorRequestDeserializer.class);
    private final SchemaService schemaService;

    public EventsCollectorRequestDeserializer(SchemaService schemaRegistry) {
        this(null, schemaRegistry);
    }

    public EventsCollectorRequestDeserializer(Class<EventsCollectorRequest> vc, SchemaService schemaService) {
        super(vc);
        this.schemaService = schemaService;
    }

    public EventsCollectorRequest deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (!this.schemaService.isValid(node.toString(), "https://unomi.apache.org/schemas/json/rest/eventscollectorrequest/1-0-0")) {
            throw new InvalidRequestException("Invalid events collector object", "Invalid received data");
        }
        ArrayList<Object> filteredEvents = new ArrayList<Object>();
        JsonNode eventsNode = node.get("events");
        if (eventsNode instanceof ArrayNode) {
            for (JsonNode event : eventsNode) {
                if (this.schemaService.isEventValid(event.toString())) {
                    filteredEvents.add(jsonParser.getCodec().treeToValue((TreeNode)event, Event.class));
                    continue;
                }
                logger.error("An event was rejected - switch to DEBUG log level for more information");
            }
        }
        EventsCollectorRequest eventsCollectorRequest = new EventsCollectorRequest();
        JsonNode sessionId = node.get("sessionId");
        if (sessionId != null) {
            eventsCollectorRequest.setSessionId(sessionId.textValue());
        }
        eventsCollectorRequest.setEvents(filteredEvents);
        return eventsCollectorRequest;
    }
}

