/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.util.ObjectHelper;

class MethodsFilter {
    private final List<Method> methods = new ArrayList<Method>();
    private final Class<?> inheritingClass;

    public MethodsFilter(Class<?> clazz) {
        this.inheritingClass = clazz;
    }

    void filterMethod(Method proposedMethod) {
        if (proposedMethod.isBridge()) {
            return;
        }
        for (int i = 0; i < this.methods.size(); ++i) {
            Method alreadyRegistered = this.methods.get(i);
            if (!Modifier.isPublic(proposedMethod.getDeclaringClass().getModifiers())) continue;
            boolean overridden = ObjectHelper.isOverridingMethod(this.inheritingClass, proposedMethod, alreadyRegistered, false);
            boolean overridding = ObjectHelper.isOverridingMethod(this.inheritingClass, alreadyRegistered, proposedMethod, false);
            boolean registeredMethodIsPublic = Modifier.isPublic(alreadyRegistered.getDeclaringClass().getModifiers());
            if (overridden && !registeredMethodIsPublic) {
                this.methods.set(i, proposedMethod);
                return;
            }
            if (!overridding) continue;
            this.methods.set(i, proposedMethod);
            return;
        }
        this.methods.add(proposedMethod);
    }

    List<Method> asReadOnlyList() {
        return Collections.unmodifiableList(this.methods);
    }
}

