/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.support.expressiondsl.expressions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.security.support.expressiondsl.RoleMapperExpression;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class CompositeRoleMapperExpression
implements RoleMapperExpression {
    private final String name;
    private final List<RoleMapperExpression> elements;

    CompositeRoleMapperExpression(String name, RoleMapperExpression ... elements) {
        assert (name != null) : "field name cannot be null";
        assert (elements != null) : "at least one field expression is required";
        this.name = name;
        this.elements = Collections.unmodifiableList(Arrays.asList(elements));
    }

    public String getName() {
        return this.name;
    }

    public List<RoleMapperExpression> getElements() {
        return this.elements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeRoleMapperExpression that = (CompositeRoleMapperExpression)o;
        if (!Objects.equals(this.getName(), that.getName())) {
            return false;
        }
        return Objects.equals(this.getElements(), that.getElements());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.elements);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(this.name);
        for (RoleMapperExpression e : this.elements) {
            e.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }
}

