/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.client.subsystem.sftp.fs.SftpFileSystem;
import org.apache.sshd.client.subsystem.sftp.impl.DefaultSftpClientFactory;

public interface SftpClientFactory {
    public static SftpClientFactory instance() {
        return DefaultSftpClientFactory.INSTANCE;
    }

    default public SftpClient createSftpClient(ClientSession session) throws IOException {
        return this.createSftpClient(session, SftpVersionSelector.CURRENT);
    }

    default public SftpClient createSftpClient(ClientSession session, int version) throws IOException {
        return this.createSftpClient(session, SftpVersionSelector.fixedVersionSelector(version));
    }

    public SftpClient createSftpClient(ClientSession var1, SftpVersionSelector var2) throws IOException;

    default public SftpFileSystem createSftpFileSystem(ClientSession session) throws IOException {
        return this.createSftpFileSystem(session, SftpVersionSelector.CURRENT);
    }

    default public SftpFileSystem createSftpFileSystem(ClientSession session, int version) throws IOException {
        return this.createSftpFileSystem(session, SftpVersionSelector.fixedVersionSelector(version));
    }

    default public SftpFileSystem createSftpFileSystem(ClientSession session, SftpVersionSelector selector) throws IOException {
        return this.createSftpFileSystem(session, selector, 0, 0);
    }

    default public SftpFileSystem createSftpFileSystem(ClientSession session, int version, int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(session, SftpVersionSelector.fixedVersionSelector(version), readBufferSize, writeBufferSize);
    }

    default public SftpFileSystem createSftpFileSystem(ClientSession session, int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(session, SftpVersionSelector.CURRENT, readBufferSize, writeBufferSize);
    }

    public SftpFileSystem createSftpFileSystem(ClientSession var1, SftpVersionSelector var2, int var3, int var4) throws IOException;
}

