/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.conditions;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.util.IOUtils;
import org.apache.lucene.analysis.charfilter.MappingCharFilterFactory;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.scripting.ScriptExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionContextHelper {
    private static final Logger logger = LoggerFactory.getLogger(ConditionContextHelper.class);
    private static MappingCharFilterFactory mappingCharFilterFactory;

    public static Condition getContextualCondition(Condition condition, Map<String, Object> context, ScriptExecutor scriptExecutor) {
        if (!ConditionContextHelper.hasContextualParameter(condition.getParameterValues())) {
            return condition;
        }
        Map values = (Map)ConditionContextHelper.parseParameter(context, condition.getParameterValues(), scriptExecutor);
        if (values == null) {
            return null;
        }
        Condition n = new Condition(condition.getConditionType());
        n.setParameterValues(values);
        return n;
    }

    private static Object parseParameter(Map<String, Object> context, Object value, ScriptExecutor scriptExecutor) {
        if (value instanceof String) {
            if (((String)value).startsWith("parameter::") || ((String)value).startsWith("script::")) {
                String s = (String)value;
                if (s.startsWith("parameter::")) {
                    return context.get(StringUtils.substringAfter((String)s, (String)"parameter::"));
                }
                if (s.startsWith("script::")) {
                    String script = StringUtils.substringAfter((String)s, (String)"script::");
                    return scriptExecutor.execute(script, context);
                }
            }
        } else {
            if (value instanceof Map) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object parameter = ConditionContextHelper.parseParameter(context, entry.getValue(), scriptExecutor);
                    if (parameter == null) {
                        return null;
                    }
                    values.put((String)entry.getKey(), parameter);
                }
                return values;
            }
            if (value instanceof List) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object o : (List)value) {
                    Object parameter = ConditionContextHelper.parseParameter(context, o, scriptExecutor);
                    if (parameter == null) continue;
                    values.add(parameter);
                }
                return values;
            }
        }
        return value;
    }

    private static boolean hasContextualParameter(Object value) {
        block4: {
            block5: {
                block3: {
                    if (!(value instanceof String)) break block3;
                    if (((String)value).startsWith("parameter::") || ((String)value).startsWith("script::")) {
                        return true;
                    }
                    break block4;
                }
                if (!(value instanceof Map)) break block5;
                for (Object o : ((Map)value).values()) {
                    if (!ConditionContextHelper.hasContextualParameter(o)) continue;
                    return true;
                }
                break block4;
            }
            if (!(value instanceof List)) break block4;
            for (Object o : (List)value) {
                if (!ConditionContextHelper.hasContextualParameter(o)) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] foldToASCII(String[] s) {
        if (s != null) {
            for (int i = 0; i < s.length; ++i) {
                s[i] = ConditionContextHelper.foldToASCII(s[i]);
            }
        }
        return s;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String foldToASCII(String s) {
        if (s != null) {
            s = s.toLowerCase();
            try (StringReader stringReader = new StringReader(s);){
                String string;
                block14: {
                    Reader foldedStringReader = mappingCharFilterFactory.create((Reader)stringReader);
                    try {
                        string = IOUtils.toString((Reader)foldedStringReader);
                        if (foldedStringReader == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (foldedStringReader != null) {
                            try {
                                foldedStringReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    foldedStringReader.close();
                }
                return string;
            }
            catch (IOException e) {
                logger.error("Error folding to ASCII string " + s, (Throwable)e);
            }
        }
        return null;
    }

    public static <T> List<T> foldToASCII(List<T> s) {
        if (s != null) {
            return Lists.transform(s, (Function)new Function<T, T>(){

                public T apply(T o) {
                    if (o instanceof String) {
                        return ConditionContextHelper.foldToASCII((String)o);
                    }
                    return o;
                }
            });
        }
        return null;
    }

    static {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("mapping", "mapping-FoldToASCII.txt");
        mappingCharFilterFactory = new MappingCharFilterFactory(args);
        try {
            mappingCharFilterFactory.inform((ResourceLoader)new ClasspathResourceLoader(ConditionContextHelper.class.getClassLoader()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

