/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.DeleteTopicsResponse;

public class DeleteTopicsRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.DELETE_TOPICS.id);
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private final Set<String> topics;
    private final Integer timeout;

    public DeleteTopicsRequest(Set<String> topics, Integer timeout) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        this.struct.set(TIMEOUT_KEY_NAME, (Object)timeout);
        this.topics = topics;
        this.timeout = timeout;
    }

    public DeleteTopicsRequest(Struct struct) {
        super(struct);
        Object[] topicsArray = struct.getArray(TOPICS_KEY_NAME);
        HashSet<String> topics = new HashSet<String>(topicsArray.length);
        for (Object topic : topicsArray) {
            topics.add((String)topic);
        }
        this.topics = topics;
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        HashMap<String, Errors> topicErrors = new HashMap<String, Errors>();
        for (String topic : this.topics) {
            topicErrors.put(topic, Errors.forException(e));
        }
        switch (versionId) {
            case 0: {
                return new DeleteTopicsResponse(topicErrors);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.DELETE_TOPICS.id)));
    }

    public Set<String> topics() {
        return this.topics;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public static DeleteTopicsRequest parse(ByteBuffer buffer, int versionId) {
        return new DeleteTopicsRequest(ProtoUtils.parseRequest(ApiKeys.DELETE_TOPICS.id, versionId, buffer));
    }

    public static DeleteTopicsRequest parse(ByteBuffer buffer) {
        return new DeleteTopicsRequest(CURRENT_SCHEMA.read(buffer));
    }
}

