/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.services.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.shell.services.UnomiManagementService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class UnomiManagementServiceImpl
implements UnomiManagementService {
    private BundleContext bundleContext;
    private List<String> bundleSymbolicNames;
    private List<String> reversedBundleSymbolicNames;

    public void init() throws BundleException {
        this.initReversedBundleSymbolicNames();
        if (StringUtils.isNotBlank((CharSequence)this.bundleContext.getProperty("unomi.autoStart")) && this.bundleContext.getProperty("unomi.autoStart").equals("true")) {
            this.startUnomi();
        }
    }

    @Override
    public void startUnomi() throws BundleException {
        block0: for (String bundleSymbolicName : this.bundleSymbolicNames) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (!bundle.getSymbolicName().equals(bundleSymbolicName)) continue;
                if (bundle.getState() != 4) continue block0;
                bundle.start();
                continue block0;
            }
        }
    }

    @Override
    public void stopUnomi() throws BundleException {
        block0: for (String bundleSymbolicName : this.reversedBundleSymbolicNames) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (!bundle.getSymbolicName().equals(bundleSymbolicName)) continue;
                if (bundle.getState() != 32) continue block0;
                bundle.stop();
                continue block0;
            }
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setBundleSymbolicNames(List<String> bundleSymbolicNames) {
        this.bundleSymbolicNames = bundleSymbolicNames;
    }

    public void initReversedBundleSymbolicNames() {
        if (this.reversedBundleSymbolicNames == null || this.reversedBundleSymbolicNames.isEmpty()) {
            this.reversedBundleSymbolicNames = new ArrayList<String>();
            this.reversedBundleSymbolicNames.addAll(this.bundleSymbolicNames);
            Collections.reverse(this.reversedBundleSymbolicNames);
        }
    }
}

