/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.camel.spi.ClassResolver;
import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.CompositeFileEntryParser;
import org.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.MVSFTPEntryParser;
import org.apache.commons.net.ftp.parser.MacOsPeterFTPEntryParser;
import org.apache.commons.net.ftp.parser.NTFTPEntryParser;
import org.apache.commons.net.ftp.parser.NetwareFTPEntryParser;
import org.apache.commons.net.ftp.parser.OS2FTPEntryParser;
import org.apache.commons.net.ftp.parser.OS400FTPEntryParser;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.commons.net.ftp.parser.UnixFTPEntryParser;
import org.apache.commons.net.ftp.parser.VMSVersioningFTPEntryParser;

public class OsgiParserFactory
extends DefaultFTPFileEntryParserFactory {
    private static final String JAVA_IDENTIFIER = "\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*";
    private static final String JAVA_QUALIFIED_NAME = "(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*\\.)+\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*";
    private static final Pattern JAVA_QUALIFIED_NAME_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*\\.)+\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*");
    private ClassResolver ocr;

    public OsgiParserFactory(ClassResolver ocr) {
        this.ocr = ocr;
    }

    public void setClassResolver(ClassResolver ocr) {
        this.ocr = ocr;
    }

    public FTPFileEntryParser createFileEntryParser(String key) {
        if (key == null) {
            throw new ParserInitializationException("Parser key cannot be null");
        }
        return this.createFileEntryParser(key, null);
    }

    public FTPFileEntryParser createFileEntryParser(FTPClientConfig config) throws ParserInitializationException {
        String key = config.getServerSystemKey();
        return this.createFileEntryParser(key, config);
    }

    private FTPFileEntryParser createFileEntryParser(String key, FTPClientConfig config) {
        FTPFileEntryParser parser = null;
        if (JAVA_QUALIFIED_NAME_PATTERN.matcher(key).matches()) {
            Class parserClass = this.ocr.resolveClass(key);
            try {
                parser = (FTPFileEntryParser)parserClass.newInstance();
            }
            catch (ClassCastException e) {
                throw new ParserInitializationException(parserClass.getName() + " does not implement the interface org.apache.commons.net.ftp.FTPFileEntryParser.", (Throwable)e);
            }
            catch (Exception | ExceptionInInitializerError e) {
                throw new ParserInitializationException("Error initializing parser", e);
            }
        }
        if (parser == null) {
            String ukey = key.toUpperCase(Locale.ENGLISH);
            if (ukey.contains("UNIX")) {
                parser = new UnixFTPEntryParser(config);
            } else if (ukey.contains("LINUX")) {
                parser = new UnixFTPEntryParser(config);
            } else if (ukey.contains("VMS")) {
                parser = new VMSVersioningFTPEntryParser(config);
            } else if (ukey.contains("WINDOWS")) {
                parser = this.createNTFTPEntryParser(config);
            } else if (ukey.contains("WIN32")) {
                parser = this.createNTFTPEntryParser(config);
            } else if (ukey.contains("OS/2")) {
                parser = new OS2FTPEntryParser(config);
            } else if (ukey.contains("OS/400") || ukey.contains("AS/400")) {
                parser = this.createOS400FTPEntryParser(config);
            } else if (ukey.contains("MVS")) {
                parser = new MVSFTPEntryParser();
            } else if (ukey.contains("NETWARE")) {
                parser = new NetwareFTPEntryParser(config);
            } else if (ukey.contains("MACOS PETER")) {
                parser = new MacOsPeterFTPEntryParser(config);
            } else if (ukey.contains("TYPE: L8")) {
                parser = new UnixFTPEntryParser(config);
            } else {
                throw new ParserInitializationException("Unknown parser type: " + key);
            }
        }
        if (parser instanceof Configurable) {
            ((Configurable)parser).configure(config);
        }
        return parser;
    }

    private FTPFileEntryParser createNTFTPEntryParser(FTPClientConfig config) {
        if (config != null && "WINDOWS".equals(config.getServerSystemKey())) {
            return new NTFTPEntryParser(config);
        }
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new NTFTPEntryParser(config), new UnixFTPEntryParser(config)});
    }

    private FTPFileEntryParser createOS400FTPEntryParser(FTPClientConfig config) {
        if (config != null && "OS/400".equals(config.getServerSystemKey())) {
            return new OS400FTPEntryParser(config);
        }
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new OS400FTPEntryParser(config), new UnixFTPEntryParser(config)});
    }
}

