/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.util.Path;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultHttpContext
implements WebContainerContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpContext.class);
    protected final Bundle bundle;
    protected final String contextID;

    DefaultHttpContext(Bundle bundle, String contextID) {
        NullArgumentException.validateNotNull(bundle, "Bundle");
        this.bundle = bundle;
        this.contextID = contextID == null || contextID.equals("") ? "default" : contextID;
    }

    public boolean handleSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return true;
    }

    public URL getResource(String name) {
        String normalizedname = Path.normalizeResourcePath((String)name);
        LOG.debug("Searching bundle [" + this.bundle + "] for resource [" + normalizedname + "]");
        return this.bundle.getResource(normalizedname);
    }

    public String getMimeType(String name) {
        return null;
    }

    public Set<String> getResourcePaths(String name) {
        String normalizedname = Path.normalizeResourcePath((String)name);
        LOG.debug("Searching bundle [" + this.bundle + "] for resource paths of [" + normalizedname + "]");
        Enumeration entryPaths = this.bundle.getEntryPaths(normalizedname);
        if (entryPaths == null || !entryPaths.hasMoreElements()) {
            return null;
        }
        HashSet<String> foundPaths = new HashSet<String>();
        while (entryPaths.hasMoreElements()) {
            foundPaths.add((String)entryPaths.nextElement());
        }
        return foundPaths;
    }

    public String getContextId() {
        return this.contextID;
    }

    public String toString() {
        return "DefaultHttpContext [bundle=" + this.bundle + ", contextID=" + this.contextID + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundle == null ? 0 : this.bundle.hashCode());
        result = 31 * result + (this.contextID == null ? 0 : this.contextID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultHttpContext other = (DefaultHttpContext)obj;
        if (this.bundle == null ? other.bundle != null : !this.bundle.equals(other.bundle)) {
            return false;
        }
        return !(this.contextID == null ? other.contextID != null : !this.contextID.equals(other.contextID));
    }
}

