/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationEnumValue;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassInfoUnlinked;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodTypeSignature;
import io.github.classgraph.Resource;
import io.github.classgraph.TypeSignature;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.types.Parser;
import nonapi.io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import nonapi.io.github.classgraph.utils.LogNode;

class ClassfileBinaryParser {
    private InputStreamOrByteBufferAdapter inputStreamOrByteBuffer;
    private String className;
    private int[] offset;
    private int[] tag;
    private int[] indirectStringRefs;
    private static final AnnotationInfo[] NO_ANNOTATIONS = new AnnotationInfo[0];

    ClassfileBinaryParser() {
    }

    private int getConstantPoolStringOffset(int cpIdx, int subFieldIdx) throws IllegalArgumentException {
        int cpIdxToUse;
        int t = this.tag[cpIdx];
        if (t != 12 && subFieldIdx != 0 || t == 12 && subFieldIdx != 0 && subFieldIdx != 1) {
            throw new IllegalArgumentException("Bad subfield index " + subFieldIdx + " for tag " + t + ", cannot continue reading class. Please report this at https://github.com/classgraph/classgraph/issues");
        }
        if (t == 0) {
            return 0;
        }
        if (t == 1) {
            cpIdxToUse = cpIdx;
        } else if (t == 7 || t == 8 || t == 19) {
            int indirIdx = this.indirectStringRefs[cpIdx];
            if (indirIdx == -1) {
                throw new IllegalArgumentException("Bad string indirection index, cannot continue reading class. Please report this at https://github.com/classgraph/classgraph/issues");
            }
            if (indirIdx == 0) {
                return 0;
            }
            cpIdxToUse = indirIdx;
        } else if (t == 12) {
            int compoundIndirIdx = this.indirectStringRefs[cpIdx];
            if (compoundIndirIdx == -1) {
                throw new IllegalArgumentException("Bad string indirection index, cannot continue reading class. Please report this at https://github.com/classgraph/classgraph/issues");
            }
            int indirIdx = (subFieldIdx == 0 ? compoundIndirIdx >> 16 : compoundIndirIdx) & 0xFFFF;
            if (indirIdx == 0) {
                throw new IllegalArgumentException("Bad string indirection index, cannot continue reading class. Please report this at https://github.com/classgraph/classgraph/issues");
            }
            cpIdxToUse = indirIdx;
        } else {
            throw new IllegalArgumentException("Wrong tag number " + t + " at constant pool index " + cpIdx + ", cannot continue reading class. Please report this at https://github.com/classgraph/classgraph/issues");
        }
        return this.offset[cpIdxToUse];
    }

    private String getConstantPoolString(int cpIdx, boolean replaceSlashWithDot, boolean stripLSemicolon) throws IllegalArgumentException, IOException {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(cpIdx, 0);
        return constantPoolStringOffset == 0 ? null : this.inputStreamOrByteBuffer.readString(constantPoolStringOffset, replaceSlashWithDot, stripLSemicolon);
    }

    private String getConstantPoolString(int cpIdx, int subFieldIdx) throws IllegalArgumentException, IOException {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(cpIdx, subFieldIdx);
        return constantPoolStringOffset == 0 ? null : this.inputStreamOrByteBuffer.readString(constantPoolStringOffset, false, false);
    }

    private String getConstantPoolString(int cpIdx) throws IllegalArgumentException, IOException {
        return this.getConstantPoolString(cpIdx, 0);
    }

    private byte getConstantPoolStringFirstByte(int cpIdx) throws IllegalArgumentException {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(cpIdx, 0);
        if (constantPoolStringOffset == 0) {
            return 0;
        }
        int utfLen = this.inputStreamOrByteBuffer.readUnsignedShort(constantPoolStringOffset);
        if (utfLen == 0) {
            return 0;
        }
        return this.inputStreamOrByteBuffer.buf[constantPoolStringOffset + 2];
    }

    private String getConstantPoolClassName(int CpIdx) throws IllegalArgumentException, IOException {
        return this.getConstantPoolString(CpIdx, true, false);
    }

    private String getConstantPoolClassDescriptor(int CpIdx) throws IllegalArgumentException, IOException {
        return this.getConstantPoolString(CpIdx, true, true);
    }

    private boolean constantPoolStringEquals(int cpIdx, String otherString) throws IllegalArgumentException {
        int otherLen;
        int strOffset = this.getConstantPoolStringOffset(cpIdx, 0);
        if (strOffset == 0) {
            return otherString == null;
        }
        if (otherString == null) {
            return false;
        }
        int strLen = this.inputStreamOrByteBuffer.readUnsignedShort(strOffset);
        if (strLen != (otherLen = otherString.length())) {
            return false;
        }
        int strStart = strOffset + 2;
        for (int i = 0; i < strLen; ++i) {
            if ((char)(this.inputStreamOrByteBuffer.buf[strStart + i] & 0xFF) == otherString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private Object getFieldConstantPoolValue(int tag, char fieldTypeDescriptorFirstChar, int cpIdx) throws IllegalArgumentException, IOException {
        switch (tag) {
            case 1: 
            case 7: 
            case 8: {
                return this.getConstantPoolString(cpIdx);
            }
            case 3: {
                int intVal = this.inputStreamOrByteBuffer.readInt(this.offset[cpIdx]);
                switch (fieldTypeDescriptorFirstChar) {
                    case 'I': {
                        return intVal;
                    }
                    case 'S': {
                        return (short)intVal;
                    }
                    case 'C': {
                        return Character.valueOf((char)intVal);
                    }
                    case 'B': {
                        return (byte)intVal;
                    }
                    case 'Z': {
                        return intVal != 0;
                    }
                }
                throw new IllegalArgumentException("Unknown Constant_INTEGER type " + fieldTypeDescriptorFirstChar + ", cannot continue reading class. Please report this at https://github.com/classgraph/classgraph/issues");
            }
            case 4: {
                return Float.valueOf(Float.intBitsToFloat(this.inputStreamOrByteBuffer.readInt(this.offset[cpIdx])));
            }
            case 5: {
                return this.inputStreamOrByteBuffer.readLong(this.offset[cpIdx]);
            }
            case 6: {
                return Double.longBitsToDouble(this.inputStreamOrByteBuffer.readLong(this.offset[cpIdx]));
            }
        }
        throw new IllegalArgumentException("Unknown constant pool tag " + tag + ", cannot continue reading class. Please report this at https://github.com/classgraph/classgraph/issues");
    }

    private AnnotationInfo readAnnotation() throws IOException, IllegalArgumentException {
        String annotationClassName = this.getConstantPoolClassDescriptor(this.inputStreamOrByteBuffer.readUnsignedShort());
        int numElementValuePairs = this.inputStreamOrByteBuffer.readUnsignedShort();
        AnnotationParameterValueList paramVals = null;
        if (numElementValuePairs > 0) {
            paramVals = new AnnotationParameterValueList(numElementValuePairs);
            for (int i = 0; i < numElementValuePairs; ++i) {
                String paramName = this.getConstantPoolString(this.inputStreamOrByteBuffer.readUnsignedShort());
                Object paramValue = this.readAnnotationElementValue();
                paramVals.add(new AnnotationParameterValue(paramName, paramValue));
            }
        }
        return new AnnotationInfo(annotationClassName, paramVals);
    }

    private Object readAnnotationElementValue() throws IOException, IllegalArgumentException {
        char tag = (char)this.inputStreamOrByteBuffer.readUnsignedByte();
        switch (tag) {
            case 'B': {
                return (byte)this.inputStreamOrByteBuffer.readInt(this.offset[this.inputStreamOrByteBuffer.readUnsignedShort()]);
            }
            case 'C': {
                return Character.valueOf((char)this.inputStreamOrByteBuffer.readInt(this.offset[this.inputStreamOrByteBuffer.readUnsignedShort()]));
            }
            case 'D': {
                return Double.longBitsToDouble(this.inputStreamOrByteBuffer.readLong(this.offset[this.inputStreamOrByteBuffer.readUnsignedShort()]));
            }
            case 'F': {
                return Float.valueOf(Float.intBitsToFloat(this.inputStreamOrByteBuffer.readInt(this.offset[this.inputStreamOrByteBuffer.readUnsignedShort()])));
            }
            case 'I': {
                return this.inputStreamOrByteBuffer.readInt(this.offset[this.inputStreamOrByteBuffer.readUnsignedShort()]);
            }
            case 'J': {
                return this.inputStreamOrByteBuffer.readLong(this.offset[this.inputStreamOrByteBuffer.readUnsignedShort()]);
            }
            case 'S': {
                return (short)this.inputStreamOrByteBuffer.readInt(this.offset[this.inputStreamOrByteBuffer.readUnsignedShort()]);
            }
            case 'Z': {
                return this.inputStreamOrByteBuffer.readInt(this.offset[this.inputStreamOrByteBuffer.readUnsignedShort()]) != 0;
            }
            case 's': {
                return this.getConstantPoolString(this.inputStreamOrByteBuffer.readUnsignedShort());
            }
            case 'e': {
                String className = this.getConstantPoolClassDescriptor(this.inputStreamOrByteBuffer.readUnsignedShort());
                String constName = this.getConstantPoolString(this.inputStreamOrByteBuffer.readUnsignedShort());
                return new AnnotationEnumValue(className, constName);
            }
            case 'c': {
                String classRefTypeDescriptor = this.getConstantPoolString(this.inputStreamOrByteBuffer.readUnsignedShort());
                return new AnnotationClassRef(classRefTypeDescriptor);
            }
            case '@': {
                return this.readAnnotation();
            }
            case '[': {
                int count = this.inputStreamOrByteBuffer.readUnsignedShort();
                Object[] arr = new Object[count];
                for (int i = 0; i < count; ++i) {
                    arr[i] = this.readAnnotationElementValue();
                }
                return arr;
            }
        }
        throw new IllegalArgumentException("Class " + this.className + " has unknown annotation element type tag '" + (char)tag + "': element size unknown, cannot continue reading class. Please report this at https://github.com/classgraph/classgraph/issues");
    }

    private ClassInfoUnlinked readClassfile(ClasspathElement classpathElement, String relativePath, boolean isExternalClass, Resource classfileResource, ScanSpec scanSpec, LogNode log) throws IOException, IllegalArgumentException {
        int k;
        int attributeLength;
        int attributeNameCpIdx;
        int j;
        int classModifierFlags;
        HashSet<String> refdClassNames;
        this.inputStreamOrByteBuffer.readUnsignedShort();
        this.inputStreamOrByteBuffer.readUnsignedShort();
        ArrayList<Integer> constClassInfoCpIdxs = scanSpec.enableInterClassDependencies ? new ArrayList<Integer>() : null;
        ArrayList<Integer> typeSignatureIdxs = scanSpec.enableInterClassDependencies ? new ArrayList<Integer>() : null;
        int cpCount = this.inputStreamOrByteBuffer.readUnsignedShort();
        if (this.offset == null || this.offset.length < cpCount) {
            this.offset = new int[cpCount];
            this.tag = new int[cpCount];
            this.indirectStringRefs = new int[cpCount];
        }
        Arrays.fill(this.indirectStringRefs, 0, cpCount, -1);
        block21: for (int i = 1; i < cpCount; ++i) {
            this.tag[i] = this.inputStreamOrByteBuffer.readUnsignedByte();
            this.offset[i] = this.inputStreamOrByteBuffer.curr;
            switch (this.tag[i]) {
                case 0: {
                    throw new IllegalArgumentException("Unknown constant pool tag 0 in classfile " + relativePath + " (possible buffer underflow issue). Please report this at https://github.com/classgraph/classgraph/issues");
                }
                case 1: {
                    int strLen = this.inputStreamOrByteBuffer.readUnsignedShort();
                    this.inputStreamOrByteBuffer.skip(strLen);
                    continue block21;
                }
                case 3: 
                case 4: {
                    this.inputStreamOrByteBuffer.skip(4);
                    continue block21;
                }
                case 5: 
                case 6: {
                    this.inputStreamOrByteBuffer.skip(8);
                    ++i;
                    continue block21;
                }
                case 7: {
                    this.indirectStringRefs[i] = this.inputStreamOrByteBuffer.readUnsignedShort();
                    if (!scanSpec.enableInterClassDependencies || this.tag[i] != 7) continue block21;
                    constClassInfoCpIdxs.add(this.indirectStringRefs[i]);
                    continue block21;
                }
                case 8: {
                    this.indirectStringRefs[i] = this.inputStreamOrByteBuffer.readUnsignedShort();
                    continue block21;
                }
                case 9: {
                    this.inputStreamOrByteBuffer.skip(4);
                    continue block21;
                }
                case 10: {
                    this.inputStreamOrByteBuffer.skip(4);
                    continue block21;
                }
                case 11: {
                    this.inputStreamOrByteBuffer.skip(4);
                    continue block21;
                }
                case 12: {
                    int nameRef = this.inputStreamOrByteBuffer.readUnsignedShort();
                    int typeRef = this.inputStreamOrByteBuffer.readUnsignedShort();
                    if (scanSpec.enableInterClassDependencies) {
                        typeSignatureIdxs.add(typeRef);
                    }
                    this.indirectStringRefs[i] = nameRef << 16 | typeRef;
                    continue block21;
                }
                case 15: {
                    this.inputStreamOrByteBuffer.skip(3);
                    continue block21;
                }
                case 16: {
                    this.inputStreamOrByteBuffer.skip(2);
                    continue block21;
                }
                case 18: {
                    this.inputStreamOrByteBuffer.skip(4);
                    continue block21;
                }
                case 19: {
                    this.indirectStringRefs[i] = this.inputStreamOrByteBuffer.readUnsignedShort();
                    continue block21;
                }
                case 20: {
                    this.inputStreamOrByteBuffer.skip(2);
                    continue block21;
                }
                default: {
                    throw new IllegalArgumentException("Unknown constant pool tag " + this.tag[i] + " in classfile " + relativePath + " (element size unknown, cannot continue reading class). Please report this at https://github.com/classgraph/classgraph/issues");
                }
            }
        }
        if (scanSpec.enableInterClassDependencies) {
            HierarchicalTypeSignature typeSig;
            int cpIdx;
            refdClassNames = new HashSet<String>();
            Iterator strLen = constClassInfoCpIdxs.iterator();
            while (strLen.hasNext()) {
                cpIdx = (Integer)strLen.next();
                String className = this.getConstantPoolString(cpIdx, true, false);
                if (className == null) continue;
                if (className.startsWith("[")) {
                    try {
                        typeSig = TypeSignature.parse(className.replace('.', '/'), null);
                        typeSig.getReferencedClassNames(refdClassNames);
                    }
                    catch (Parser.ParseException e) {
                        if (log == null) continue;
                        log.log("Could not parse type signature: " + className + " : " + e);
                    }
                    continue;
                }
                refdClassNames.add(className);
            }
            strLen = typeSignatureIdxs.iterator();
            while (strLen.hasNext()) {
                cpIdx = (Integer)strLen.next();
                String typeSigStr = this.getConstantPoolString(cpIdx);
                if (typeSigStr == null) continue;
                try {
                    if (typeSigStr.indexOf(40) >= 0 || typeSigStr.equals("<init>")) {
                        typeSig = MethodTypeSignature.parse(typeSigStr, null);
                        ((MethodTypeSignature)typeSig).getReferencedClassNames(refdClassNames);
                        continue;
                    }
                    typeSig = TypeSignature.parse(typeSigStr, null);
                    typeSig.getReferencedClassNames(refdClassNames);
                }
                catch (Parser.ParseException e) {
                    if (log == null) continue;
                    log.log("Could not parse type signature: " + typeSigStr + " : " + e);
                }
            }
        } else {
            refdClassNames = null;
        }
        boolean isInterface = ((classModifierFlags = this.inputStreamOrByteBuffer.readUnsignedShort()) & 0x200) != 0;
        boolean isAnnotation = (classModifierFlags & 0x2000) != 0;
        boolean isModule = (classModifierFlags & 0x8000) != 0;
        boolean isPackage = relativePath.regionMatches(relativePath.lastIndexOf(47) + 1, "package-info.class", 0, 18);
        String classNamePath = this.getConstantPoolString(this.inputStreamOrByteBuffer.readUnsignedShort());
        this.className = classNamePath.replace('/', '.');
        if ("java.lang.Object".equals(this.className)) {
            if (log != null) {
                log.log("Skipping " + this.className);
            }
            return null;
        }
        if (!(scanSpec.ignoreClassVisibility || Modifier.isPublic(classModifierFlags) || isModule || isPackage)) {
            if (log != null) {
                log.log("Skipping non-public class: " + this.className);
            }
            return null;
        }
        if (!relativePath.endsWith(".class")) {
            if (log != null) {
                log.log("File " + relativePath + " does not end in \".class\"");
            }
            return null;
        }
        int len = classNamePath.length();
        if (relativePath.length() != len + 6 || !classNamePath.regionMatches(0, relativePath, 0, len)) {
            if (log != null) {
                log.log("Class " + this.className + " is at incorrect relative path " + relativePath + " -- ignoring");
            }
            return null;
        }
        int superclassNameCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
        String superclassName = superclassNameCpIdx > 0 ? this.getConstantPoolClassName(superclassNameCpIdx) : null;
        ClassInfoUnlinked classInfoUnlinked = new ClassInfoUnlinked(this.className, superclassName, classModifierFlags, isInterface, isAnnotation, isExternalClass, refdClassNames, classpathElement, classfileResource);
        int interfaceCount = this.inputStreamOrByteBuffer.readUnsignedShort();
        for (int i = 0; i < interfaceCount; ++i) {
            String interfaceName = this.getConstantPoolClassName(this.inputStreamOrByteBuffer.readUnsignedShort());
            classInfoUnlinked.addImplementedInterface(interfaceName);
        }
        int fieldCount = this.inputStreamOrByteBuffer.readUnsignedShort();
        for (int i = 0; i < fieldCount; ++i) {
            boolean getStaticFinalFieldConstValue;
            int fieldModifierFlags = this.inputStreamOrByteBuffer.readUnsignedShort();
            boolean isPublicField = (fieldModifierFlags & 1) == 1;
            boolean isStaticFinalField = (fieldModifierFlags & 0x18) == 24;
            boolean fieldIsVisible = isPublicField || scanSpec.ignoreFieldVisibility;
            boolean bl = getStaticFinalFieldConstValue = scanSpec.enableStaticFinalFieldConstantInitializerValues && isStaticFinalField && fieldIsVisible;
            if (!fieldIsVisible || !scanSpec.enableFieldInfo && !getStaticFinalFieldConstValue) {
                this.inputStreamOrByteBuffer.readUnsignedShort();
                this.inputStreamOrByteBuffer.readUnsignedShort();
                int attributesCount = this.inputStreamOrByteBuffer.readUnsignedShort();
                for (int j2 = 0; j2 < attributesCount; ++j2) {
                    this.inputStreamOrByteBuffer.readUnsignedShort();
                    int attributeLength2 = this.inputStreamOrByteBuffer.readInt();
                    this.inputStreamOrByteBuffer.skip(attributeLength2);
                }
                continue;
            }
            int fieldNameCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
            String fieldName = this.getConstantPoolString(fieldNameCpIdx);
            int fieldTypeDescriptorCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
            char fieldTypeDescriptorFirstChar = (char)this.getConstantPoolStringFirstByte(fieldTypeDescriptorCpIdx);
            String fieldTypeSignature = null;
            String fieldTypeDescriptor = this.getConstantPoolString(fieldTypeDescriptorCpIdx);
            Object fieldConstValue = null;
            AnnotationInfoList fieldAnnotationInfo = null;
            int attributesCount = this.inputStreamOrByteBuffer.readUnsignedShort();
            for (j = 0; j < attributesCount; ++j) {
                attributeNameCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                attributeLength = this.inputStreamOrByteBuffer.readInt();
                if (getStaticFinalFieldConstValue && this.constantPoolStringEquals(attributeNameCpIdx, "ConstantValue")) {
                    int cpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                    fieldConstValue = this.getFieldConstantPoolValue(this.tag[cpIdx], fieldTypeDescriptorFirstChar, cpIdx);
                    continue;
                }
                if (fieldIsVisible && this.constantPoolStringEquals(attributeNameCpIdx, "Signature")) {
                    fieldTypeSignature = this.getConstantPoolString(this.inputStreamOrByteBuffer.readUnsignedShort());
                    continue;
                }
                if (scanSpec.enableAnnotationInfo && (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleAnnotations") || !scanSpec.disableRuntimeInvisibleAnnotations && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleAnnotations"))) {
                    int fieldAnnotationCount = this.inputStreamOrByteBuffer.readUnsignedShort();
                    if (fieldAnnotationInfo == null && fieldAnnotationCount > 0) {
                        fieldAnnotationInfo = new AnnotationInfoList(1);
                    }
                    if (fieldAnnotationInfo == null) continue;
                    for (k = 0; k < fieldAnnotationCount; ++k) {
                        AnnotationInfo fieldAnnotation = this.readAnnotation();
                        fieldAnnotationInfo.add(fieldAnnotation);
                    }
                    continue;
                }
                this.inputStreamOrByteBuffer.skip(attributeLength);
            }
            if (!scanSpec.enableFieldInfo || !fieldIsVisible) continue;
            classInfoUnlinked.addFieldInfo(new FieldInfo(this.className, fieldName, fieldModifierFlags, fieldTypeDescriptor, fieldTypeSignature, fieldConstValue, fieldAnnotationInfo));
        }
        int methodCount = this.inputStreamOrByteBuffer.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            boolean enableMethodInfo;
            int methodModifierFlags = this.inputStreamOrByteBuffer.readUnsignedShort();
            boolean isPublicMethod = (methodModifierFlags & 1) == 1;
            boolean methodIsVisible = isPublicMethod || scanSpec.ignoreMethodVisibility;
            String methodName = null;
            String methodTypeDescriptor = null;
            String methodTypeSignature = null;
            boolean bl = enableMethodInfo = scanSpec.enableMethodInfo || isAnnotation;
            if (enableMethodInfo || isAnnotation) {
                int methodNameCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                methodName = this.getConstantPoolString(methodNameCpIdx);
                int methodTypeDescriptorCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                methodTypeDescriptor = this.getConstantPoolString(methodTypeDescriptorCpIdx);
            } else {
                this.inputStreamOrByteBuffer.skip(4);
            }
            int attributesCount = this.inputStreamOrByteBuffer.readUnsignedShort();
            String[] methodParameterNames = null;
            int[] methodParameterModifiers = null;
            AnnotationInfo[][] methodParameterAnnotations = null;
            AnnotationInfoList methodAnnotationInfo = null;
            boolean methodHasBody = false;
            if (!methodIsVisible || !enableMethodInfo && !isAnnotation) {
                for (j = 0; j < attributesCount; ++j) {
                    this.inputStreamOrByteBuffer.skip(2);
                    int attributeLength3 = this.inputStreamOrByteBuffer.readInt();
                    this.inputStreamOrByteBuffer.skip(attributeLength3);
                }
                continue;
            }
            for (j = 0; j < attributesCount; ++j) {
                attributeNameCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                attributeLength = this.inputStreamOrByteBuffer.readInt();
                if (scanSpec.enableAnnotationInfo && (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleAnnotations") || !scanSpec.disableRuntimeInvisibleAnnotations && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleAnnotations"))) {
                    int methodAnnotationCount = this.inputStreamOrByteBuffer.readUnsignedShort();
                    if (methodAnnotationInfo == null && methodAnnotationCount > 0) {
                        methodAnnotationInfo = new AnnotationInfoList(1);
                    }
                    if (methodAnnotationInfo == null) continue;
                    for (k = 0; k < methodAnnotationCount; ++k) {
                        AnnotationInfo annotationInfo = this.readAnnotation();
                        methodAnnotationInfo.add(annotationInfo);
                    }
                    continue;
                }
                if (scanSpec.enableAnnotationInfo && (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleParameterAnnotations") || !scanSpec.disableRuntimeInvisibleAnnotations && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleParameterAnnotations"))) {
                    int paramCount = this.inputStreamOrByteBuffer.readUnsignedByte();
                    methodParameterAnnotations = new AnnotationInfo[paramCount][];
                    for (k = 0; k < paramCount; ++k) {
                        int numAnnotations = this.inputStreamOrByteBuffer.readUnsignedShort();
                        methodParameterAnnotations[k] = numAnnotations == 0 ? NO_ANNOTATIONS : new AnnotationInfo[numAnnotations];
                        for (int l = 0; l < numAnnotations; ++l) {
                            methodParameterAnnotations[k][l] = this.readAnnotation();
                        }
                    }
                    continue;
                }
                if (this.constantPoolStringEquals(attributeNameCpIdx, "MethodParameters")) {
                    int paramCount = this.inputStreamOrByteBuffer.readUnsignedByte();
                    methodParameterNames = new String[paramCount];
                    methodParameterModifiers = new int[paramCount];
                    for (k = 0; k < paramCount; ++k) {
                        int cpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                        methodParameterNames[k] = cpIdx == 0 ? null : this.getConstantPoolString(cpIdx);
                        methodParameterModifiers[k] = this.inputStreamOrByteBuffer.readUnsignedShort();
                    }
                    continue;
                }
                if (this.constantPoolStringEquals(attributeNameCpIdx, "Signature")) {
                    methodTypeSignature = this.getConstantPoolString(this.inputStreamOrByteBuffer.readUnsignedShort());
                    continue;
                }
                if (this.constantPoolStringEquals(attributeNameCpIdx, "AnnotationDefault")) {
                    Object annotationParamDefaultValue = this.readAnnotationElementValue();
                    classInfoUnlinked.addAnnotationParamDefaultValue(new AnnotationParameterValue(methodName, annotationParamDefaultValue));
                    continue;
                }
                if (this.constantPoolStringEquals(attributeNameCpIdx, "Code")) {
                    methodHasBody = true;
                    this.inputStreamOrByteBuffer.skip(attributeLength);
                    continue;
                }
                this.inputStreamOrByteBuffer.skip(attributeLength);
            }
            if (!enableMethodInfo) continue;
            classInfoUnlinked.addMethodInfo(new MethodInfo(this.className, methodName, methodAnnotationInfo, methodModifierFlags, methodTypeDescriptor, methodTypeSignature, methodParameterNames, methodParameterModifiers, methodParameterAnnotations, methodHasBody));
        }
        int attributesCount = this.inputStreamOrByteBuffer.readUnsignedShort();
        for (int i = 0; i < attributesCount; ++i) {
            int attributeNameCpIdx2 = this.inputStreamOrByteBuffer.readUnsignedShort();
            int attributeLength4 = this.inputStreamOrByteBuffer.readInt();
            if (scanSpec.enableAnnotationInfo && (this.constantPoolStringEquals(attributeNameCpIdx2, "RuntimeVisibleAnnotations") || !scanSpec.disableRuntimeInvisibleAnnotations && this.constantPoolStringEquals(attributeNameCpIdx2, "RuntimeInvisibleAnnotations"))) {
                int annotationCount = this.inputStreamOrByteBuffer.readUnsignedShort();
                for (int m = 0; m < annotationCount; ++m) {
                    AnnotationInfo classAnnotation = this.readAnnotation();
                    classInfoUnlinked.addClassAnnotation(classAnnotation);
                }
                continue;
            }
            if (this.constantPoolStringEquals(attributeNameCpIdx2, "InnerClasses")) {
                int numInnerClasses = this.inputStreamOrByteBuffer.readUnsignedShort();
                for (int j3 = 0; j3 < numInnerClasses; ++j3) {
                    int innerClassInfoCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                    int outerClassInfoCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                    if (innerClassInfoCpIdx != 0 && outerClassInfoCpIdx != 0) {
                        classInfoUnlinked.addClassContainment(this.getConstantPoolClassName(innerClassInfoCpIdx), this.getConstantPoolClassName(outerClassInfoCpIdx));
                    }
                    this.inputStreamOrByteBuffer.skip(2);
                    this.inputStreamOrByteBuffer.skip(2);
                }
                continue;
            }
            if (this.constantPoolStringEquals(attributeNameCpIdx2, "Signature")) {
                classInfoUnlinked.addTypeSignature(this.getConstantPoolString(this.inputStreamOrByteBuffer.readUnsignedShort()));
                continue;
            }
            if (this.constantPoolStringEquals(attributeNameCpIdx2, "EnclosingMethod")) {
                String innermostEnclosingClassName = this.getConstantPoolClassName(this.inputStreamOrByteBuffer.readUnsignedShort());
                int enclosingMethodCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                String definingMethodName = enclosingMethodCpIdx == 0 ? "<clinit>" : this.getConstantPoolString(enclosingMethodCpIdx, 0);
                classInfoUnlinked.addClassContainment(this.className, innermostEnclosingClassName);
                classInfoUnlinked.addEnclosingMethod(innermostEnclosingClassName + "." + definingMethodName);
                continue;
            }
            if (this.constantPoolStringEquals(attributeNameCpIdx2, "Module")) {
                int moduleNameCpIdx = this.inputStreamOrByteBuffer.readUnsignedShort();
                String moduleName = this.getConstantPoolString(moduleNameCpIdx);
                if (moduleName == null) {
                    moduleName = "";
                }
                classpathElement.moduleName = moduleName;
                this.inputStreamOrByteBuffer.skip(attributeLength4 - 2);
                continue;
            }
            this.inputStreamOrByteBuffer.skip(attributeLength4);
        }
        return classInfoUnlinked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassInfoUnlinked readClassInfoFromClassfileHeader(ClasspathElement classpathElement, String relativePath, Resource classfileResource, boolean isExternalClass, ScanSpec scanSpec, LogNode log) throws IOException, IllegalArgumentException {
        try {
            this.inputStreamOrByteBuffer = classfileResource.openOrRead();
            this.inputStreamOrByteBuffer.readInitialChunk();
            if (this.inputStreamOrByteBuffer.readInt() != -889275714) {
                throw new IllegalArgumentException("Classfile " + relativePath + " does not have correct classfile magic number");
            }
            ClassInfoUnlinked classInfoUnlinked = this.readClassfile(classpathElement, relativePath, isExternalClass, classfileResource, scanSpec, log);
            return classInfoUnlinked;
        }
        finally {
            classfileResource.close();
            this.inputStreamOrByteBuffer = null;
        }
    }
}

