/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.memoize;

import aQute.lib.memoize.Memoize;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

class PredicateMemoizingSupplier<T>
implements Memoize<T> {
    private volatile boolean initial;
    private Object memoized;

    PredicateMemoizingSupplier(Supplier<? extends T> supplier, Predicate<? super T> predicate) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(predicate);
        this.memoized = () -> {
            Object result = supplier.get();
            if (predicate.test((T)result)) {
                this.memoized = result;
                this.initial = false;
            }
            return result;
        };
        this.initial = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.initial) {
            PredicateMemoizingSupplier predicateMemoizingSupplier = this;
            synchronized (predicateMemoizingSupplier) {
                if (this.initial) {
                    return ((Supplier)this.memoized).get();
                }
            }
        }
        return (T)this.memoized;
    }

    @Override
    public T peek() {
        if (this.initial) {
            return null;
        }
        return (T)this.memoized;
    }
}

