/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.network.LoginType;
import org.apache.kafka.common.security.auth.Login;
import org.apache.kafka.common.security.authenticator.DefaultLogin;
import org.apache.kafka.common.security.kerberos.KerberosLogin;

public class LoginManager {
    private static final EnumMap<LoginType, LoginManager> CACHED_INSTANCES = new EnumMap(LoginType.class);
    private final Login login;
    private final LoginType loginType;
    private int refCount;

    private LoginManager(LoginType loginType, boolean hasKerberos, Map<String, ?> configs) throws IOException, LoginException {
        this.loginType = loginType;
        String loginContext = loginType.contextName();
        this.login = hasKerberos ? new KerberosLogin() : new DefaultLogin();
        this.login.configure(configs, loginContext);
        this.login.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LoginManager acquireLoginManager(LoginType loginType, boolean hasKerberos, Map<String, ?> configs) throws IOException, LoginException {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            LoginManager loginManager = CACHED_INSTANCES.get((Object)loginType);
            if (loginManager == null) {
                loginManager = new LoginManager(loginType, hasKerberos, configs);
                CACHED_INSTANCES.put(loginType, loginManager);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return loginManager.acquire();
        }
    }

    public Subject subject() {
        return this.login.subject();
    }

    public String serviceName() {
        return this.login.serviceName();
    }

    private LoginManager acquire() {
        ++this.refCount;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            if (this.refCount == 0) {
                throw new IllegalStateException("release called on LoginManager with refCount == 0");
            }
            if (this.refCount == 1) {
                CACHED_INSTANCES.remove((Object)this.loginType);
                this.login.close();
            }
            --this.refCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            for (LoginType loginType : new ArrayList<LoginType>(CACHED_INSTANCES.keySet())) {
                LoginManager loginManager = CACHED_INSTANCES.remove((Object)loginType);
                loginManager.login.close();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

