/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import javax.xml.bind.DatatypeConverter;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.persistence.spi.PersistenceService;

public class SetEventOccurenceCountAction
implements ActionExecutor {
    private DefinitionsService definitionsService;
    private PersistenceService persistenceService;

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public int execute(Action action, Event event) {
        LocalDateTime eventTime;
        Condition pastEventCondition = (Condition)action.getParameterValues().get("pastEventCondition");
        Condition andCondition = new Condition(this.definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Condition eventCondition = (Condition)pastEventCondition.getParameter("eventCondition");
        this.definitionsService.resolveConditionType(eventCondition);
        conditions.add(eventCondition);
        Condition c = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
        c.setParameter("propertyName", (Object)"profileId");
        c.setParameter("comparisonOperator", (Object)"equals");
        c.setParameter("propertyValue", (Object)event.getProfileId());
        conditions.add(c);
        Integer numberOfDays = (Integer)pastEventCondition.getParameter("numberOfDays");
        String fromDate = (String)pastEventCondition.getParameter("fromDate");
        String toDate = (String)pastEventCondition.getParameter("toDate");
        if (numberOfDays != null) {
            Condition numberOfDaysCondition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
            numberOfDaysCondition.setParameter("propertyName", (Object)"timeStamp");
            numberOfDaysCondition.setParameter("comparisonOperator", (Object)"greaterThan");
            numberOfDaysCondition.setParameter("propertyValueDateExpr", (Object)("now-" + numberOfDays + "d"));
            conditions.add(numberOfDaysCondition);
        }
        if (fromDate != null) {
            Condition startDateCondition = new Condition();
            startDateCondition.setConditionType(this.definitionsService.getConditionType("eventPropertyCondition"));
            startDateCondition.setParameter("propertyName", (Object)"timeStamp");
            startDateCondition.setParameter("comparisonOperator", (Object)"greaterThanOrEqualTo");
            startDateCondition.setParameter("propertyValueDate", (Object)fromDate);
            conditions.add(startDateCondition);
        }
        if (toDate != null) {
            Condition endDateCondition = new Condition();
            endDateCondition.setConditionType(this.definitionsService.getConditionType("eventPropertyCondition"));
            endDateCondition.setParameter("propertyName", (Object)"timeStamp");
            endDateCondition.setParameter("comparisonOperator", (Object)"lessThanOrEqualTo");
            endDateCondition.setParameter("propertyValueDate", (Object)toDate);
            conditions.add(endDateCondition);
        }
        andCondition.setParameter("subConditions", conditions);
        long count = this.persistenceService.queryCount(andCondition, "event");
        LinkedHashMap<String, Long> pastEvents = (LinkedHashMap<String, Long>)event.getProfile().getSystemProperties().get("pastEvents");
        if (pastEvents == null) {
            pastEvents = new LinkedHashMap<String, Long>();
            event.getProfile().getSystemProperties().put("pastEvents", pastEvents);
        }
        LocalDateTime fromDateTime = null;
        if (fromDate != null) {
            Calendar fromDateCalendar = DatatypeConverter.parseDateTime((String)fromDate);
            fromDateTime = LocalDateTime.ofInstant(fromDateCalendar.toInstant(), ZoneId.of("UTC"));
        }
        LocalDateTime toDateTime = null;
        if (toDate != null) {
            Calendar toDateCalendar = DatatypeConverter.parseDateTime((String)toDate);
            toDateTime = LocalDateTime.ofInstant(toDateCalendar.toInstant(), ZoneId.of("UTC"));
        }
        if (this.inTimeRange(eventTime = LocalDateTime.ofInstant(event.getTimeStamp().toInstant(), ZoneId.of("UTC")), numberOfDays, fromDateTime, toDateTime)) {
            ++count;
        }
        pastEvents.put((String)pastEventCondition.getParameter("generatedPropertyKey"), count);
        return 4;
    }

    private boolean inTimeRange(LocalDateTime eventTime, Integer numberOfDays, LocalDateTime fromDate, LocalDateTime toDate) {
        boolean inTimeRange = true;
        if (numberOfDays != null) {
            long daysDiff;
            LocalDateTime now = LocalDateTime.now(ZoneId.of("UTC"));
            if (eventTime.isAfter(now)) {
                inTimeRange = false;
            }
            if ((daysDiff = Duration.between(eventTime, now).toDays()) > (long)numberOfDays.intValue()) {
                inTimeRange = false;
            }
        }
        if (fromDate != null && fromDate.isAfter(eventTime)) {
            inTimeRange = false;
        }
        if (toDate != null && toDate.isBefore(eventTime)) {
            inTimeRange = false;
        }
        return inTimeRange;
    }
}

