/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class QueryConfig
implements ToXContentObject {
    private final QueryBuilder query;

    public static QueryConfig fromXContent(XContentParser parser) throws IOException {
        QueryBuilder query = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
        return new QueryConfig(query);
    }

    public QueryConfig(QueryBuilder query) {
        this.query = query;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.query.toXContent(builder, params);
        return builder;
    }

    public QueryBuilder getQuery() {
        return this.query;
    }

    public int hashCode() {
        return Objects.hash(this.query);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryConfig that = (QueryConfig)other;
        return Objects.equals(this.query, that.query);
    }
}

