/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.component.Destroyable;

public class GZIPContentDecoder
implements ContentDecoder,
Destroyable {
    private final Inflater inflater = new Inflater(true);
    private final byte[] bytes;
    private byte[] output;
    private State state;
    private int size;
    private int value;
    private byte flags;

    public GZIPContentDecoder() {
        this(2048);
    }

    public GZIPContentDecoder(int bufferSize) {
        this.bytes = new byte[bufferSize];
        this.reset();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer decode(ByteBuffer buffer) {
        try {
            block20: while (true) {
                if (!buffer.hasRemaining()) {
                    return BufferUtil.EMPTY_BUFFER;
                }
                currByte = buffer.get();
                switch (1.$SwitchMap$org$eclipse$jetty$client$GZIPContentDecoder$State[this.state.ordinal()]) {
                    case 1: {
                        buffer.position(buffer.position() - 1);
                        this.state = State.ID;
                        continue block20;
                    }
                    case 2: {
                        this.value += (currByte & 255) << 8 * this.size;
                        ++this.size;
                        if (this.size != 2) continue block20;
                        if (this.value != 35615) {
                            throw new ZipException("Invalid gzip bytes");
                        }
                        this.state = State.CM;
                        continue block20;
                    }
                    case 3: {
                        if ((currByte & 255) != 8) {
                            throw new ZipException("Invalid gzip compression method");
                        }
                        this.state = State.FLG;
                        continue block20;
                    }
                    case 4: {
                        this.flags = currByte;
                        this.state = State.MTIME;
                        this.size = 0;
                        this.value = 0;
                        continue block20;
                    }
                    case 5: {
                        ++this.size;
                        if (this.size != 4) continue block20;
                        this.state = State.XFL;
                        continue block20;
                    }
                    case 6: {
                        this.state = State.OS;
                        continue block20;
                    }
                    case 7: {
                        this.state = State.FLAGS;
                        continue block20;
                    }
                    case 8: {
                        buffer.position(buffer.position() - 1);
                        if ((this.flags & 4) == 4) {
                            this.state = State.EXTRA_LENGTH;
                            this.size = 0;
                            this.value = 0;
                            continue block20;
                        }
                        if ((this.flags & 8) == 8) {
                            this.state = State.NAME;
                            continue block20;
                        }
                        if ((this.flags & 16) == 16) {
                            this.state = State.COMMENT;
                            continue block20;
                        }
                        if ((this.flags & 2) == 2) {
                            this.state = State.HCRC;
                            this.size = 0;
                            this.value = 0;
                            continue block20;
                        }
                        this.state = State.DATA;
                        continue block20;
                    }
                    case 9: {
                        this.value += (currByte & 255) << 8 * this.size;
                        ++this.size;
                        if (this.size != 2) continue block20;
                        this.state = State.EXTRA;
                        continue block20;
                    }
                    case 10: {
                        --this.value;
                        if (this.value != 0) continue block20;
                        this.flags = (byte)(this.flags & -5);
                        this.state = State.FLAGS;
                        continue block20;
                    }
                    case 11: {
                        if (currByte != 0) continue block20;
                        this.flags = (byte)(this.flags & -9);
                        this.state = State.FLAGS;
                        continue block20;
                    }
                    case 12: {
                        if (currByte != 0) continue block20;
                        this.flags = (byte)(this.flags & -17);
                        this.state = State.FLAGS;
                        continue block20;
                    }
                    case 13: {
                        ++this.size;
                        if (this.size != 2) continue block20;
                        this.flags = (byte)(this.flags & -3);
                        this.state = State.FLAGS;
                        continue block20;
                    }
                    case 14: {
                        buffer.position(buffer.position() - 1);
                        while (true) {
                            if ((decoded = this.inflate(this.bytes)) == 0) {
                                if (this.inflater.needsInput()) {
                                    if (buffer.hasRemaining()) {
                                        input = new byte[buffer.remaining()];
                                        buffer.get(input);
                                        this.inflater.setInput(input);
                                        continue;
                                    }
                                    if (this.output == null) continue block20;
                                    result = ByteBuffer.wrap(this.output);
                                    this.output = null;
                                    return result;
                                }
                                if (!this.inflater.finished()) {
                                    throw new ZipException("Invalid inflater state");
                                }
                                remaining = this.inflater.getRemaining();
                                buffer.position(buffer.limit() - remaining);
                                this.state = State.CRC;
                                this.size = 0;
                                this.value = 0;
                                continue block20;
                            }
                            if (this.output == null) {
                                this.output = Arrays.copyOf(this.bytes, decoded);
                                continue;
                            }
                            newOutput = Arrays.copyOf(this.output, this.output.length + decoded);
                            System.arraycopy(this.bytes, 0, newOutput, this.output.length, decoded);
                            this.output = newOutput;
                        }
                    }
                    case 15: {
                        this.value += (currByte & 255) << 8 * this.size;
                        ++this.size;
                        if (this.size != 4) continue block20;
                        this.state = State.ISIZE;
                        this.size = 0;
                        this.value = 0;
                        continue block20;
                    }
                    case 16: {
                        this.value += (currByte & 255) << 8 * this.size;
                        ++this.size;
                        if (this.size == 4) ** break;
                        continue block20;
                        if ((long)this.value != this.inflater.getBytesWritten()) {
                            throw new ZipException("Invalid input size");
                        }
                        result = this.output == null ? BufferUtil.EMPTY_BUFFER : ByteBuffer.wrap(this.output);
                        this.reset();
                        return result;
                    }
                }
                break;
            }
            throw new ZipException();
        }
        catch (ZipException x) {
            throw new RuntimeException(x);
        }
    }

    private int inflate(byte[] bytes) throws ZipException {
        try {
            return this.inflater.inflate(bytes);
        }
        catch (DataFormatException x) {
            throw new ZipException(x.getMessage());
        }
    }

    private void reset() {
        this.inflater.reset();
        Arrays.fill(this.bytes, (byte)0);
        this.output = null;
        this.state = State.INITIAL;
        this.size = 0;
        this.value = 0;
        this.flags = 0;
    }

    public void destroy() {
        this.inflater.end();
    }

    protected boolean isFinished() {
        return this.state == State.INITIAL;
    }

    private static enum State {
        INITIAL,
        ID,
        CM,
        FLG,
        MTIME,
        XFL,
        OS,
        FLAGS,
        EXTRA_LENGTH,
        EXTRA,
        NAME,
        COMMENT,
        HCRC,
        DATA,
        CRC,
        ISIZE;

    }

    public static class Factory
    extends ContentDecoder.Factory {
        private final int bufferSize;

        public Factory() {
            this(2048);
        }

        public Factory(int bufferSize) {
            super("gzip");
            this.bufferSize = bufferSize;
        }

        @Override
        public ContentDecoder newContentDecoder() {
            return new GZIPContentDecoder(this.bufferSize);
        }
    }
}

