/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadUtils.class);

    public static ThreadFactory getThreadFactory(String factoryName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(factoryName + "-%d").build();
    }

    public static ThreadFactory getNettyThreadFactory(String threadPoolPrefix) {
        return new DefaultThreadFactory(threadPoolPrefix, true);
    }

    public static ScheduledExecutorService getDaemonSingleThreadScheduledExecutor(String factoryName) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ThreadUtils.getThreadFactory(factoryName));
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    public static ExecutorService getDaemonFixedThreadPool(int threadNum, String factoryName) {
        return Executors.newFixedThreadPool(threadNum, ThreadUtils.getThreadFactory(factoryName));
    }

    public static ExecutorService getDaemonSingleThreadExecutor(String factoryName) {
        return Executors.newSingleThreadExecutor(ThreadUtils.getThreadFactory(factoryName));
    }

    public static ExecutorService getDaemonCachedThreadPool(String factoryName) {
        return Executors.newCachedThreadPool(ThreadUtils.getThreadFactory(factoryName));
    }

    public static void shutdownThreadPool(ExecutorService threadPool, int waitSec) throws InterruptedException {
        if (threadPool == null) {
            return;
        }
        threadPool.shutdown();
        if (!threadPool.awaitTermination(waitSec, TimeUnit.SECONDS)) {
            threadPool.shutdownNow();
            if (!threadPool.awaitTermination(waitSec, TimeUnit.SECONDS)) {
                LOGGER.warn("Thread pool don't stop gracefully.");
            }
        }
    }
}

