/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.handle;

import org.apache.uniffle.common.netty.client.TransportClient;
import org.apache.uniffle.common.netty.handle.TransportRequestHandler;
import org.apache.uniffle.common.netty.handle.TransportResponseHandler;
import org.apache.uniffle.common.netty.protocol.RequestMessage;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.io.netty.channel.ChannelHandlerContext;
import org.apache.uniffle.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.uniffle.io.netty.handler.timeout.IdleState;
import org.apache.uniffle.io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportChannelHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TransportChannelHandler.class);
    private final TransportClient client;
    private final TransportResponseHandler responseHandler;
    private final TransportRequestHandler requestHandler;
    private final long requestTimeoutNs;
    private final boolean closeIdleConnections;

    public TransportChannelHandler(TransportClient client, TransportResponseHandler responseHandler, TransportRequestHandler requestHandler, long requestTimeoutMs, boolean closeIdleConnections) {
        this.client = client;
        this.responseHandler = responseHandler;
        this.requestHandler = requestHandler;
        this.requestTimeoutNs = requestTimeoutMs * 1000L * 1000L;
        this.closeIdleConnections = closeIdleConnections;
    }

    public TransportClient getClient() {
        return this.client;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("Exception in connection from " + NettyUtils.getRemoteAddress(ctx.channel()), cause);
        this.requestHandler.exceptionCaught(cause);
        this.responseHandler.exceptionCaught(cause);
        ctx.close();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.requestHandler.channelActive();
        }
        catch (RuntimeException e) {
            logger.error("Exception from request handler while channel is active", (Throwable)e);
        }
        try {
            this.responseHandler.channelActive();
        }
        catch (RuntimeException e) {
            logger.error("Exception from response handler while channel is active", (Throwable)e);
        }
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.requestHandler.channelInactive();
        }
        catch (RuntimeException e) {
            logger.error("Exception from request handler while channel is inactive", (Throwable)e);
        }
        try {
            this.responseHandler.channelInactive();
        }
        catch (RuntimeException e) {
            logger.error("Exception from response handler while channel is inactive", (Throwable)e);
        }
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object request) throws Exception {
        if (request instanceof RequestMessage) {
            this.requestHandler.handle((RequestMessage)request);
        } else if (request instanceof RpcResponse) {
            this.responseHandler.handle((RpcResponse)request);
        } else {
            ctx.fireChannelRead(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            TransportChannelHandler transportChannelHandler = this;
            synchronized (transportChannelHandler) {
                boolean isActuallyOverdue;
                boolean bl = isActuallyOverdue = System.nanoTime() - this.responseHandler.getTimeOfLastRequestNs() > this.requestTimeoutNs;
                if (e.state() == IdleState.ALL_IDLE && isActuallyOverdue) {
                    if (this.responseHandler.numOutstandingRequests() > 0) {
                        String address = NettyUtils.getRemoteAddress(ctx.channel());
                        logger.error("Connection to {} has been quiet for {} ms while there are outstanding requests.", (Object)address, (Object)(this.requestTimeoutNs / 1000L / 1000L));
                    }
                    if (this.closeIdleConnections) {
                        this.client.timeOut();
                        ctx.close();
                    }
                }
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    public TransportResponseHandler getResponseHandler() {
        return this.responseHandler;
    }
}

