/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.resource.ResourceManager;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static ClassLoader findClassLoader() {
        ClassLoader cl;
        ClassLoader uimaThreadContextClassLoader = ClassLoaderUtils.getExtensionClassLoader(UimaContextHolder.getContext());
        if (uimaThreadContextClassLoader != null) {
            return uimaThreadContextClassLoader;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        ClassLoader uimaFITClassLoader = ClassLoaderUtils.class.getClassLoader();
        if (uimaFITClassLoader != null) {
            return uimaFITClassLoader;
        }
        try {
            cl = UIMAFramework.class.getClassLoader();
            if (cl != null) {
                return cl;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            cl = ClassLoader.getSystemClassLoader();
            if (cl != null) {
                return cl;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ClassLoader findClassLoader(ResourceManager aResMgr) {
        ClassLoader resourceManagerExtensionClassloader = ClassLoaderUtils.getExtensionClassLoader(aResMgr);
        if (resourceManagerExtensionClassloader != null) {
            return resourceManagerExtensionClassloader;
        }
        return ClassLoaderUtils.findClassLoader();
    }

    public static ClassLoader findClassLoader(UimaContext aContext) {
        ClassLoader uimaContextExtensionClassloader = ClassLoaderUtils.getExtensionClassLoader(aContext);
        if (uimaContextExtensionClassloader != null) {
            return uimaContextExtensionClassloader;
        }
        return ClassLoaderUtils.findClassLoader((ResourceManager)null);
    }

    private static ClassLoader getExtensionClassLoader(UimaContext aContext) {
        if (aContext instanceof UimaContextAdmin) {
            return ClassLoaderUtils.getExtensionClassLoader(((UimaContextAdmin)aContext).getResourceManager());
        }
        return null;
    }

    private static ClassLoader getExtensionClassLoader(ResourceManager aResMgr) {
        if (aResMgr == null) {
            return null;
        }
        ClassLoader cl = aResMgr.getExtensionClassLoader();
        if (cl != null) {
            return cl;
        }
        return null;
    }
}

