/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypePriorityList;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.TypePriorityImportSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddTypeToPriorityListDialog;
import org.apache.uima.taeconfigurator.wizards.TypePrioritiesNewWizard;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;

public class PriorityListSection
extends AbstractSection {
    public static final String PRIORITY_LIST = "<Priority List>";
    private Tree tree;
    private Button addSetButton;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private TypePriorityImportSection typePriorityImportSection;
    private Button exportButton;

    public PriorityListSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Priority Lists", "This section shows the defined Prioirity Lists");
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.enableBorders(sectionClient);
        this.tree = this.newTree(sectionClient);
        Composite buttonContainer = this.newButtonContainer(sectionClient);
        this.addSetButton = this.newPushButton(buttonContainer, "Add Set", "Click here to add another priority list.");
        this.addButton = this.newPushButton(buttonContainer, "Add...", "Click here to add a type");
        this.removeButton = this.newPushButton(buttonContainer, "Remove", "Click here to remove the selected item.  You can also use the delete key.");
        new Button(buttonContainer, 8).setVisible(false);
        this.upButton = this.newPushButton(buttonContainer, "Up", "Click here to move the selected item up in the priority order.");
        this.downButton = this.newPushButton(buttonContainer, "Down", "Click here to move the selected item down in the priority order");
        this.exportButton = this.newPushButton(buttonContainer, "Export...", "Export to an importable part, and substitute an Import for that part here");
        this.toolkit.paintBordersFor(sectionClient);
    }

    public void refresh() {
        if (null == this.typePriorityImportSection) {
            this.typePriorityImportSection = this.editor.getIndexesPage().getTypePriorityImportSection();
        }
        super.refresh();
        this.tree.removeAll();
        TypePriorities typePriorities = this.getTypePriorities();
        if (typePriorities != null) {
            TypePriorityList[] priorityLists = typePriorities.getPriorityLists();
            for (int i = 0; i < priorityLists.length; ++i) {
                TreeItem item = new TreeItem(this.tree, 0);
                item.setText(PRIORITY_LIST);
                String[] types = priorityLists[i].getTypes();
                if (null != types) {
                    for (int j = 0; j < types.length; ++j) {
                        TreeItem tItem = new TreeItem(item, 0);
                        tItem.setText(this.formatName(types[j]));
                    }
                }
                item.setExpanded(true);
            }
        }
        PriorityListSection.maybeSetSelection(this.tree, 0);
        this.enable();
    }

    public TypePriorityList getTypePriorityListFromTreeItem(TreeItem item) {
        TypePriorityList[] typePriorityLists = this.getAnalysisEngineMetaData().getTypePriorities().getPriorityLists();
        return typePriorityLists[this.tree.indexOf(item)];
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addSetButton) {
            TypePriorityList typePriorityList = UIMAFramework.getResourceSpecifierFactory().createTypePriorityList();
            TypePriorities typePriorities = this.getTypePriorities();
            if (typePriorities == null) {
                typePriorities = UIMAFramework.getResourceSpecifierFactory().createTypePriorities();
                this.getAnalysisEngineMetaData().setTypePriorities(typePriorities);
            }
            this.getTypePriorities().addPriorityList(typePriorityList);
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(PRIORITY_LIST);
            this.tree.setSelection(item);
            this.setFileDirty();
        } else if (event.widget == this.addButton) {
            AddTypeToPriorityListDialog dialog;
            if (this.editor.isTypePriorityDescriptor() && !this.editor.getIsContextLoaded()) {
                Utility.popMessage("Can''t add types here", "Types cannot be added here, because there is no loaded context type system to pick the types from", 4);
                return;
            }
            TreeItem parent = this.tree.getSelection()[0];
            if (null != parent.getParentItem()) {
                parent = parent.getParentItem();
            }
            if ((dialog = new AddTypeToPriorityListDialog((AbstractSection)this, this.editor.definedTypesWithSupers.get(), this.getTypePriorityListFromTreeItem(parent).getTypes())).open() == 1) {
                return;
            }
            TypePriorityList typePriorityList = this.getTypePriorityListFromTreeItem(parent);
            String[] newTypeNames = dialog.getSelectedTypeNames();
            for (int i = 0; i < newTypeNames.length; ++i) {
                typePriorityList.addType(newTypeNames[i]);
                TreeItem item = new TreeItem(parent, 0);
                item.setText(this.formatName(newTypeNames[i]));
            }
            this.setFileDirty();
        } else if (event.widget == this.removeButton) {
            TreeItem item = this.tree.getSelection()[0];
            TreeItem parent = item.getParentItem();
            if (null == parent) {
                if (1 == Utility.popOkCancel("ConfirmRemove", "ConfirmRemoveSet", 4)) {
                    return;
                }
                TypePriorityList removedTypePriorityList = this.getTypePriorityListFromTreeItem(item);
                TypePriorityList[] oldPriorityLists = this.getAnalysisEngineMetaData().getTypePriorities().getPriorityLists();
                TypePriorityList[] newPriorityLists = new TypePriorityList[oldPriorityLists.length - 1];
                int j = 0;
                for (int i = 0; i < oldPriorityLists.length; ++i) {
                    if (oldPriorityLists[i] == removedTypePriorityList) continue;
                    newPriorityLists[j++] = oldPriorityLists[i];
                }
                this.getAnalysisEngineMetaData().getTypePriorities().setPriorityLists(newPriorityLists);
            } else {
                if (1 == Utility.popOkCancel("ConfirmRemove", "ConfirmRemoveType", 4)) {
                    return;
                }
                TypePriorityList typePriorityList = this.getTypePriorityListFromTreeItem(parent);
                typePriorityList.removeType(item.getText());
            }
            TreeItem previousSelection = this.getPreviousSelection(parent == null ? this.tree.getItems() : parent.getItems(), item);
            if (null != previousSelection) {
                this.tree.setSelection(previousSelection);
            }
            item.dispose();
            this.setFileDirty();
        } else if (event.widget == this.downButton || event.widget == this.upButton) {
            TreeItem item = this.tree.getSelection()[0];
            TreeItem parent = item.getParentItem();
            TreeItem[] items = parent.getItems();
            int i = this.getItemIndex(items, item);
            TypePriorityList typePriorityList = this.getTypePriorityListFromTreeItem(parent);
            String[] types = typePriorityList.getTypes();
            String temp = types[i];
            if (event.widget == this.downButton) {
                types[i] = types[i + 1];
                types[i + 1] = temp;
                typePriorityList.setTypes(types);
                new TreeItem(parent, 0, i).setText(this.formatName(types[i]));
                t = new TreeItem(parent, 0, i + 1);
                t.setText(this.formatName(types[i + 1]));
                this.tree.setSelection(t);
                items[i].dispose();
                items[i + 1].dispose();
            } else {
                types[i] = types[i - 1];
                types[i - 1] = temp;
                typePriorityList.setTypes(types);
                t = new TreeItem(parent, 0, i - 1);
                t.setText(this.formatName(types[i - 1]));
                this.tree.setSelection(t);
                new TreeItem(parent, 0, i).setText(this.formatName(types[i]));
                items[i - 1].dispose();
                items[i].dispose();
                this.setFileDirty();
            }
            TypePriorityList[] tpl = this.getTypePriorities().getPriorityLists();
            tpl[this.tree.indexOf((TreeItem)parent)] = typePriorityList;
            this.getTypePriorities().setPriorityLists(tpl);
        } else if (event.widget == this.exportButton) {
            this.typePriorityImportSection.exportImportablePart("<typePriorities>", TypePrioritiesNewWizard.TYPEPRIORITIES_TEMPLATE);
            this.refresh();
        }
        this.enable();
    }

    @Override
    public void enable() {
        if (this.tree.getSelectionCount() == 1) {
            this.addButton.setEnabled(true);
            TreeItem item = this.tree.getSelection()[0];
            this.removeButton.setEnabled(true);
            if (null != item.getParentItem()) {
                TreeItem[] items = item.getParentItem().getItems();
                int i = this.getItemIndex(items, item);
                this.upButton.setEnabled(i > 0);
                this.downButton.setEnabled(i < items.length - 1);
            }
        } else {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        this.exportButton.setEnabled(this.tree.getItemCount() > 0);
    }
}

