/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.internal.util.Common_hash_support;
import org.apache.uima.internal.util.Misc;

public class ObjHashSet<T>
extends Common_hash_support
implements Set<T> {
    private final T removedMarker;
    private final Class<T> clazz;
    private T[] keys;

    public ObjHashSet(Class<T> clazz, T removedMarker) {
        this(12, clazz, removedMarker);
    }

    public ObjHashSet(int initialCapacity, Class<T> clazz, T removedMarker) {
        super(initialCapacity);
        this.clazz = clazz;
        this.newTable(initialCapacity);
        this.removedMarker = removedMarker;
    }

    public ObjHashSet(ObjHashSet<T> ohs) {
        super(ohs);
        this.removedMarker = ohs.removedMarker;
        this.clazz = ohs.clazz;
        this.keys = Arrays.copyOf(ohs.keys, ohs.keys.length);
    }

    public ObjHashSet(ObjHashSet<T> ohs, boolean readOnly) {
        this(ohs);
        if (!readOnly) {
            Misc.internalError();
        }
    }

    private int findPosition(T key) {
        if (key == null) {
            throw new IllegalArgumentException("null is an invalid key");
        }
        if (key == this.removedMarker) {
            throw new IllegalArgumentException("A removed marker is an invalid key");
        }
        return this.findPosition(Misc.hashInt(key.hashCode()), i -> this.keys[i] == null || this.keys[i].equals(key), i -> this.keys[i] == this.removedMarker);
    }

    @Override
    public boolean contains(Object obj) {
        return this.clazz.isAssignableFrom(obj.getClass()) ? this.find(obj) != -1 : false;
    }

    public int find(T obj) {
        if (obj == null || this.size() == 0) {
            return -1;
        }
        int pos = this.findPosition(obj);
        return obj.equals(this.keys[pos]) ? pos : -1;
    }

    @Override
    public boolean add(T obj) {
        int i = this.findPosition(obj);
        if (obj.equals(this.keys[i])) {
            return false;
        }
        this.keys[this.found_removed != -1 ? this.found_removed : i] = obj;
        this.commonPutOrAddNotFound();
        return true;
    }

    private void addInner(T obj) {
        int i = this.findPosition(obj);
        assert (this.keys[i] == null);
        this.keys[i] = obj;
    }

    @Override
    public boolean remove(Object rawKey) {
        if (rawKey == null) {
            return false;
        }
        int pos = this.findPosition(rawKey);
        if (this.keys[pos] == null) {
            return false;
        }
        this.keys[pos] = this.removedMarker;
        this.commonRemove();
        return true;
    }

    private void removeAtPosition(int pos) {
        this.keys[pos] = this.removedMarker;
        this.commonRemove();
    }

    public T get(int index) {
        T obj = this.keys[index];
        if (obj == null || obj == this.removedMarker) {
            return null;
        }
        return obj;
    }

    @Override
    public Iterator<T> iterator() {
        return new ObjHashSetIterator();
    }

    private int moveToFirst() {
        return this.size() == 0 ? -1 : this.moveToNextFilled(0);
    }

    public int moveTo(FeatureStructure fs) {
        int pos;
        if (this.clazz.isAssignableFrom(fs.getClass()) && (pos = this.find(fs)) >= 0) {
            return pos;
        }
        return -1;
    }

    @Override
    public <T2> T2[] toArray(T2[] a) {
        int s = this.size();
        if (s == 0) {
            if (a.length >= 1) {
                a[0] = null;
            }
            return a;
        }
        T2[] r = a.length >= s ? a : (Object[])Array.newInstance(a.getClass(), s);
        int pos = this.moveToFirst();
        for (int i = 0; i < s; ++i) {
            r[i] = this.get(pos);
            pos = this.moveToNextFilled(pos + 1);
        }
        if (a.length > s) {
            r[s] = null;
        }
        return r;
    }

    @Override
    public T[] toArray() {
        return this.toArray((T2[])((Object[])Array.newInstance(this.clazz, this.size())));
    }

    public String toString() {
        return String.format("%s [loadFactor=%s, initialCapacity=%s, sizeWhichTriggersExpansion=%s, size=%s, secondTimeShrinkable=%s%n keys=%s]", this.getClass().getName(), Float.valueOf(this.loadFactor), this.initialCapacity, this.sizeWhichTriggersExpansion, this.size(), this.secondTimeShrinkable, Arrays.toString(this.keys));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        c.stream().allMatch(item -> this.contains(item));
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean[] anyChanged = new boolean[]{false};
        c.stream().forEach(item -> {
            anyChanged[0] = anyChanged[0] | this.add((T)item);
        });
        return anyChanged[0];
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean[] anyChanged = new boolean[]{false};
        c.stream().forEach(item -> {
            anyChanged[0] = anyChanged[0] | this.remove(item);
        });
        return anyChanged[0];
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean anyChanged = false;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            T v = it.next();
            if (c.contains(v)) continue;
            anyChanged = true;
            it.remove();
        }
        return anyChanged;
    }

    @Override
    protected boolean is_valid_key(int pos) {
        return this.keys[pos] != null & this.keys[pos] != this.removedMarker;
    }

    @Override
    protected int keys_length() {
        return this.keys.length;
    }

    @Override
    protected void newKeysAndValues(int capacity) {
        this.keys = (Object[])Array.newInstance(this.clazz, capacity);
    }

    @Override
    protected void clearKeysAndValues() {
        Arrays.fill(this.keys, null);
    }

    @Override
    protected void copy_to_new_table(int new_capacity, int old_capacity, Common_hash_support.CommonCopyOld2New commonCopy) {
        Object[] oldKeys = this.keys;
        commonCopy.apply(i -> this.addInner(oldKeys[i]), i -> oldKeys[i] != null && oldKeys[i] != this.removedMarker);
    }

    private class ObjHashSetIterator
    implements Iterator<T> {
        protected int curPosition;

        private ObjHashSetIterator() {
            this.curPosition = ObjHashSet.this.moveToNextFilled(0);
        }

        @Override
        public final boolean hasNext() {
            return this.curPosition < ObjHashSet.this.getCapacity();
        }

        @Override
        public final T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object r = ObjHashSet.this.get(this.curPosition);
            this.curPosition = ObjHashSet.this.moveToNextFilled(this.curPosition + 1);
            return r;
        }

        @Override
        public void remove() {
            int pos = ObjHashSet.this.moveToPreviousFilled(this.curPosition - 1);
            if (pos >= 0) {
                ObjHashSet.this.removeAtPosition(pos);
            }
        }
    }
}

