/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.apache.uima.jcas.cas.TOP;

public class JCasRegistry {
    private static final ArrayList<WeakRefInt<Class<? extends TOP>>> loadedJCasClasses = new ArrayList();
    private static final ReferenceQueue<Class<? extends TOP>> releasedQueue = new ReferenceQueue();

    private JCasRegistry() {
    }

    public static synchronized int register(Class<? extends TOP> aJCasCoverClass) {
        WeakRefInt releasedWeakRefInt = (WeakRefInt)releasedQueue.poll();
        if (releasedWeakRefInt != null) {
            int i = releasedWeakRefInt.index;
            loadedJCasClasses.set(i, new WeakRefInt<Class<? extends TOP>>(aJCasCoverClass, releasedQueue, i));
            return i;
        }
        int i = loadedJCasClasses.size();
        loadedJCasClasses.add(new WeakRefInt<Class<? extends TOP>>(aJCasCoverClass, releasedQueue, i));
        return i;
    }

    public static boolean getFeatOkTst(String fullyQualTypeName) {
        return true;
    }

    public static synchronized int getNumberOfRegisteredClasses() {
        return loadedJCasClasses.size();
    }

    public static synchronized Class<? extends TOP> getClassForIndex(int aIndex) {
        if (aIndex >= 0 && aIndex < loadedJCasClasses.size()) {
            return (Class)loadedJCasClasses.get(aIndex).get();
        }
        return null;
    }

    private static class WeakRefInt<T>
    extends WeakReference<T> {
        int index;

        WeakRefInt(T item, ReferenceQueue<? super T> q, int index) {
            super(item, q);
            this.index = index;
        }
    }
}

