/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.List;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.SearchMonitoringThread;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.SearchThread;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FindComponentDialog
extends AbstractDialog {
    private Text searchByNameText;
    private Text inputTypeText;
    private Text outputTypeText;
    private CCombo lookInCombo;
    private List m_matchingDelegateComponetDescriptors;
    private List m_matchingDelegateComponentDescriptions;
    private Button cancelButton;
    public static final String ALL_PROJECTS = "All projects";
    private Label statusLabel1;
    private Label statusLabel2;
    private SearchThread m_searchThread = null;
    private String[] componentHeaders;
    private static final String needToEscapeTheseChars = ".+{}()\\";

    public FindComponentDialog(AbstractSection aSection, String title, String header, String[] componentHeaders) {
        super(aSection, title, header);
        this.componentHeaders = componentHeaders;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        AbstractSection.spacer(composite);
        new Label(composite, 64).setText("Descriptor file name pattern (e.g. ab*cde):");
        this.searchByNameText = new Text(composite, 2048);
        this.searchByNameText.setLayoutData((Object)new GridData(768));
        new Label(composite, 64).setText("Descriptor must specify the input type:");
        this.inputTypeText = new Text(composite, 2048);
        this.inputTypeText.setLayoutData((Object)new GridData(768));
        new Label(composite, 64).setText("Descriptor must specify the output type:");
        this.outputTypeText = new Text(composite, 2048);
        this.outputTypeText.setLayoutData((Object)new GridData(768));
        new Label(composite, 64).setText("Look in:");
        this.lookInCombo = new CCombo(composite, 0x800808);
        String[] projectNames = this.getProjectNames();
        this.lookInCombo.add(" All projects");
        for (int i = 0; i < projectNames.length; ++i) {
            this.lookInCombo.add(' ' + projectNames[i]);
        }
        this.lookInCombo.setText(" All projects");
        this.statusLabel1 = new Label(composite, 0);
        this.statusLabel1.setLayoutData((Object)new GridData(768));
        this.statusLabel2 = new Label(composite, 0);
        this.statusLabel2.setLayoutData((Object)new GridData(768));
        this.newErrorMessage(composite);
        return composite;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Search", true);
        this.cancelButton = this.createButton(parent, 1, "Stop Search", false);
        this.cancelButton.setEnabled(false);
    }

    private String[] getProjectNames() {
        IProject[] projects = TAEConfiguratorPlugin.getWorkspace().getRoot().getProjects();
        String[] projectNames = new String[projects.length];
        for (int i = 0; i < projects.length; ++i) {
            projectNames[i] = projects[i].getName();
        }
        return projectNames;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (null != this.m_searchThread) {
                this.errorMessageUI.setText("Search already in progress");
            } else {
                this.copyValuesFromGUI();
            }
        } else {
            if (this.m_searchThread.isDone()) {
                this.m_matchingDelegateComponetDescriptors = this.m_searchThread.getMatchingDelegateComponentDescriptors();
                this.m_matchingDelegateComponentDescriptions = this.m_searchThread.getMatchingDelegateComponentDescriptions();
                this.m_searchThread = null;
                super.superButtonPressed(0);
            } else {
                this.m_searchThread.setDieNow();
                this.handleShellCloseEvent();
            }
            return;
        }
    }

    private String convertToRegexSearchPattern(String searchPattern) {
        if (searchPattern == null || searchPattern.equals("")) {
            return null;
        }
        String searchPatternLowerCase = searchPattern.toLowerCase();
        StringBuffer buffer = new StringBuffer("(?i)");
        for (int i = 0; i < searchPatternLowerCase.length(); ++i) {
            char ch = searchPatternLowerCase.charAt(i);
            if (ch == '*') {
                buffer.append(".*");
                continue;
            }
            if (0 <= needToEscapeTheseChars.indexOf(ch)) {
                buffer.append('\\').append(ch);
                continue;
            }
            buffer.append(ch);
        }
        return new String(buffer);
    }

    public List getMatchingDelegateComponentDescriptors() {
        return this.m_matchingDelegateComponetDescriptors;
    }

    public List getMatchingDelegateComponentDescriptions() {
        return this.m_matchingDelegateComponentDescriptions;
    }

    public Label getStatusLabel1() {
        return this.statusLabel1;
    }

    public Label getStatusLabel2() {
        return this.statusLabel2;
    }

    @Override
    public void copyValuesFromGUI() {
        String fileNameSearch = this.convertToRegexSearchPattern(this.searchByNameText.getText());
        String inputTypeSearch = this.convertToRegexSearchPattern(this.inputTypeText.getText());
        String outputTypeSearch = this.convertToRegexSearchPattern(this.outputTypeText.getText());
        String projectToSearch = this.lookInCombo.getText().substring(1);
        this.m_searchThread = new SearchThread(this, this.section, fileNameSearch, inputTypeSearch, outputTypeSearch, projectToSearch, this.componentHeaders);
        this.cancelButton.setEnabled(true);
        Thread searchThreadThread = new Thread(this.m_searchThread);
        searchThreadThread.start();
        SearchMonitoringThread monitoringThread = new SearchMonitoringThread(this, this.m_searchThread);
        monitoringThread.start();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void enableOK() {
    }
}

