/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.StringArrayFSImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.TOP;

public final class StringArray
extends TOP
implements Iterable<String>,
CommonPrimitiveArray<String>,
StringArrayFSImpl {
    public static final String _TypeName = "uima.cas.StringArray";
    public static final int typeIndexID;
    public static final int type;
    private final String[] theArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private StringArray() {
        this.theArray = null;
    }

    public StringArray(JCas jcas, int length) {
        super(jcas);
        this.theArray = new String[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2Size_arrays(length);
        }
    }

    public StringArray(TypeImpl t, CASImpl c, int length) {
        super(t, c);
        this.theArray = new String[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2Size_arrays(length);
        }
    }

    @Override
    public String get(int i) {
        return this.theArray[i];
    }

    @Override
    public void set(int i, String v) {
        this.theArray[i] = v;
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    @Override
    public void copyFromArray(String[] src, int srcPos, int destPos, int length) {
        System.arraycopy(src, srcPos, this.theArray, destPos, length);
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    @Override
    public void copyToArray(int srcPos, String[] dest, int destPos, int length) {
        System.arraycopy(this.theArray, srcPos, dest, destPos, length);
    }

    @Override
    public String[] toArray() {
        return Arrays.copyOf(this.theArray, this.theArray.length);
    }

    @Override
    public int size() {
        return this.theArray.length;
    }

    public String[] _getTheArray() {
        return this.theArray;
    }

    @Override
    public void copyValuesFrom(CommonArrayFS v) {
        StringArray bv = (StringArray)v;
        System.arraycopy(bv.theArray, 0, this.theArray, 0, this.theArray.length);
        this._casView.maybeLogArrayUpdates(this, 0, this.size());
    }

    @Override
    public void setArrayValueFromString(int i, String v) {
        this.set(i, v);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < StringArray.this.size();
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StringArray.this.get(this.i++);
            }
        };
    }

    public static StringArray create(JCas jcas, String[] a) {
        StringArray stringArray = new StringArray(jcas, a.length);
        stringArray.copyFromArray(a, 0, 0, a.length);
        return stringArray;
    }

    public boolean contains(String v) {
        return Misc.contains(this.theArray, v);
    }

    public Stream<String> stream() {
        return Arrays.stream(this.theArray);
    }

    static {
        type = typeIndexID = JCasRegistry.register(StringArray.class);
    }
}

