/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.net.URL;
import org.apache.uima.internal.util.Misc;

public class MsgLocalizationClassLoader {
    private static final CallClimbingClassLoader MSG_LOCALIZATION_CLASS_LOADER = new CallClimbingClassLoader();

    public static URL getResource(String name) {
        return MSG_LOCALIZATION_CLASS_LOADER.getResource(name);
    }

    public static ClassLoader getMsgLocalizationClassLoader() {
        return MSG_LOCALIZATION_CLASS_LOADER;
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        return MSG_LOCALIZATION_CLASS_LOADER.loadClass(name);
    }

    static class CallClimbingClassLoader
    extends ClassLoader {
        static final ThreadLocal<ClassLoader> original_thread_context_class_loader = new ThreadLocal();

        CallClimbingClassLoader() {
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            ClassLoader[] cls;
            ClassLoader context_classLoader;
            ClassLoader cl = original_thread_context_class_loader.get();
            if (cl != null) {
                try {
                    return cl.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (null != (context_classLoader = Thread.currentThread().getContextClassLoader()) && cl != context_classLoader) {
                try {
                    return context_classLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            for (ClassLoader ccl : cls = Misc.getCallingClass_classLoaders()) {
                if (ccl == cl || ccl == context_classLoader) continue;
                Class<?> c = null;
                try {
                    c = ccl.loadClass(name);
                    return c;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            ClassLoader[] cls;
            URL c;
            URL c2;
            ClassLoader cl = original_thread_context_class_loader.get();
            if (cl != null && null != (c2 = cl.getResource(name))) {
                return c2;
            }
            ClassLoader context_classLoader = Thread.currentThread().getContextClassLoader();
            if (null != context_classLoader && cl != context_classLoader && null != (c = context_classLoader.getResource(name))) {
                return c;
            }
            for (ClassLoader ccl : cls = Misc.getCallingClass_classLoaders()) {
                URL c3;
                if (ccl == cl || ccl == context_classLoader || null == (c3 = ccl.getResource(name))) continue;
                return c3;
            }
            return null;
        }
    }

    static class CallStack
    extends SecurityManager {
        CallStack() {
        }

        Class<?>[] getCallStack() {
            return this.getClassContext();
        }
    }
}

