/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.BooleanArrayFSImpl;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.TOP;

public final class BooleanArray
extends TOP
implements CommonPrimitiveArray<Boolean>,
BooleanArrayFSImpl,
Iterable<Boolean> {
    public static final String _TypeName = "uima.cas.BooleanArray";
    public static final int typeIndexID;
    public static final int type;
    private final boolean[] theArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private BooleanArray() {
        this.theArray = null;
    }

    public BooleanArray(JCas jcas, int length) {
        super(jcas);
        this.theArray = new boolean[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    public BooleanArray(TypeImpl t, CASImpl c, int l) {
        super(t, c);
        this.theArray = new boolean[l];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    @Override
    public boolean get(int i) {
        return this.theArray[i];
    }

    @Override
    public void set(int i, boolean v) {
        this.theArray[i] = v;
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    @Override
    public void copyFromArray(boolean[] src, int srcPos, int destPos, int length) {
        System.arraycopy(src, srcPos, this.theArray, destPos, length);
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    @Override
    public void copyToArray(int srcPos, boolean[] dest, int destPos, int length) {
        System.arraycopy(this.theArray, srcPos, dest, destPos, length);
    }

    @Override
    public boolean[] toArray() {
        return Arrays.copyOf(this.theArray, this.theArray.length);
    }

    @Override
    public int size() {
        return this.theArray.length;
    }

    @Override
    public void copyToArray(int srcPos, String[] dest, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcPos, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destPos] = Boolean.toString(this.theArray[i + srcPos]);
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcPos, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcPos, length);
        for (int i = 0; i < length; ++i) {
            this.theArray[i + destPos] = Boolean.parseBoolean(src[i + srcPos]);
        }
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    public boolean[] _getTheArray() {
        return this.theArray;
    }

    @Override
    public void copyValuesFrom(CommonArrayFS<Boolean> v) {
        BooleanArray bv = (BooleanArray)v;
        System.arraycopy(bv.theArray, 0, this.theArray, 0, this.theArray.length);
        this._casView.maybeLogArrayUpdates(this, 0, this.size());
    }

    @Override
    public void setArrayValueFromString(int i, String v) {
        this.set(i, Boolean.parseBoolean(v));
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new Iterator<Boolean>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < BooleanArray.this.size();
            }

            @Override
            public Boolean next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return BooleanArray.this.get(this.i++);
            }
        };
    }

    public static BooleanArray create(JCas jcas, boolean[] a) {
        BooleanArray booleanArray = new BooleanArray(jcas, a.length);
        booleanArray.copyFromArray(a, 0, 0, a.length);
        return booleanArray;
    }

    static {
        type = typeIndexID = JCasRegistry.register(BooleanArray.class);
    }
}

