/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.CliVersion;
import org.apache.uima.ducc.cli.CommandLine;
import org.apache.uima.ducc.cli.DuccUiUtilities;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.common.Pair;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.common.utils.IllegalConfigurationException;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.ServiceDisableEvent;
import org.apache.uima.ducc.transport.event.ServiceEnableEvent;
import org.apache.uima.ducc.transport.event.ServiceIgnoreEvent;
import org.apache.uima.ducc.transport.event.ServiceModifyEvent;
import org.apache.uima.ducc.transport.event.ServiceObserveEvent;
import org.apache.uima.ducc.transport.event.ServiceQueryEvent;
import org.apache.uima.ducc.transport.event.ServiceRegisterEvent;
import org.apache.uima.ducc.transport.event.ServiceStartEvent;
import org.apache.uima.ducc.transport.event.ServiceStopEvent;
import org.apache.uima.ducc.transport.event.ServiceUnregisterEvent;
import org.apache.uima.ducc.transport.event.cli.SpecificationProperties;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.transport.event.sm.IServiceReply;

public class DuccServiceApi
extends CliBase {
    private static String target_daemon = "orchestrator";
    String endpoint = null;
    IDuccCallback callback = null;
    IUiOptions.UiOption[] registration_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Description, IUiOptions.UiOption.Administrators, IUiOptions.UiOption.SchedulingClass, IUiOptions.UiOption.WorkingDirectory, IUiOptions.UiOption.LogDirectory, IUiOptions.UiOption.Jvm, IUiOptions.UiOption.ProcessJvmArgs, IUiOptions.UiOption.Classpath, IUiOptions.UiOption.Environment, IUiOptions.UiOption.ProcessMemorySize, IUiOptions.UiOption.ProcessDD, IUiOptions.UiOption.ProcessExecutable, IUiOptions.UiOption.ProcessExecutableArgs, IUiOptions.UiOption.ProcessInitializationTimeMax, IUiOptions.UiOption.ProcessDebug, IUiOptions.UiOption.ServiceDependency, IUiOptions.UiOption.ServiceRequestEndpoint, IUiOptions.UiOption.ServiceLinger, IUiOptions.UiOption.ServicePingArguments, IUiOptions.UiOption.ServicePingClass, IUiOptions.UiOption.ServicePingClasspath, IUiOptions.UiOption.ServicePingJvmArgs, IUiOptions.UiOption.ServicePingTimeout, IUiOptions.UiOption.ServicePingDoLog, IUiOptions.UiOption.InstanceFailureWindow, IUiOptions.UiOption.InstanceFailureLimit, IUiOptions.UiOption.InstanceInitFailureLimit, IUiOptions.UiOption.Register, IUiOptions.UiOption.Autostart, IUiOptions.UiOption.Instances};
    IUiOptions.UiOption[] unregister_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Unregister, IUiOptions.UiOption.RoleAdministrator};
    IUiOptions.UiOption[] start_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Start, IUiOptions.UiOption.Instances, IUiOptions.UiOption.RoleAdministrator};
    IUiOptions.UiOption[] stop_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Stop, IUiOptions.UiOption.Instances, IUiOptions.UiOption.RoleAdministrator};
    IUiOptions.UiOption[] enable_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Enable, IUiOptions.UiOption.RoleAdministrator};
    IUiOptions.UiOption[] disable_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Disable, IUiOptions.UiOption.RoleAdministrator};
    IUiOptions.UiOption[] observe_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Observe, IUiOptions.UiOption.RoleAdministrator};
    IUiOptions.UiOption[] ignore_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Ignore, IUiOptions.UiOption.RoleAdministrator};
    IUiOptions.UiOption[] modify_options;
    IUiOptions.UiOption[] query_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.Help, IUiOptions.UiOption.Debug, IUiOptions.UiOption.Query};
    IUiOptions.UiOption[] custom_only_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.ProcessExecutable, IUiOptions.UiOption.ProcessExecutableArgs};
    IUiOptions.UiOption[] uimaas_only_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.ProcessDD, IUiOptions.UiOption.Jvm, IUiOptions.UiOption.ProcessJvmArgs, IUiOptions.UiOption.ProcessDebug, IUiOptions.UiOption.Classpath};
    IUiOptions.UiOption[] pinger_only_options = new IUiOptions.UiOption[]{IUiOptions.UiOption.ServicePingClasspath, IUiOptions.UiOption.ServicePingJvmArgs, IUiOptions.UiOption.ServicePingTimeout, IUiOptions.UiOption.ServicePingDoLog};

    public DuccServiceApi(IDuccCallback cb) {
        this.callback = cb;
        this.modify_options = new IUiOptions.UiOption[this.registration_options.length - 2];
        int i = 0;
        for (IUiOptions.UiOption o : this.registration_options) {
            if (o == IUiOptions.UiOption.ProcessDD || o == IUiOptions.UiOption.ServiceRequestEndpoint || o == IUiOptions.UiOption.LogDirectory) continue;
            if (o == IUiOptions.UiOption.Register) {
                o = IUiOptions.UiOption.Modify;
            }
            this.modify_options[i++] = o;
        }
        this.modify_options[i++] = IUiOptions.UiOption.RoleAdministrator;
    }

    private Pair<Integer, String> getId(IUiOptions.UiOption opt) {
        String sid = this.cli_props.getProperty(opt.pname());
        if (sid == null) {
            throw new IllegalArgumentException("Missing service id: --id <id or endpoint>");
        }
        int id = -1;
        try {
            id = Integer.parseInt(sid);
            return new Pair((Object)id, null);
        }
        catch (NumberFormatException numberFormatException) {
            if (sid.startsWith(IService.ServiceType.UimaAs.decode()) || sid.startsWith(IService.ServiceType.Custom.decode())) {
                return new Pair((Object)-1, (Object)sid);
            }
            throw new IllegalArgumentException("Invalid id; must be numeric or start with " + IService.ServiceType.UimaAs.decode() + " or " + IService.ServiceType.Custom.decode() + ".");
        }
    }

    private IService.Trinary getAutostart() {
        String auto = this.cli_props.getStringProperty(IUiOptions.UiOption.Autostart.pname(), null);
        if (auto == null) {
            return IService.Trinary.Unset;
        }
        boolean val = Boolean.parseBoolean(auto);
        IService.Trinary answer = IService.Trinary.encode((String)(val ? "true" : "false"));
        if (answer == IService.Trinary.Unset) {
            throw new IllegalArgumentException("--" + IUiOptions.UiOption.Autostart.pname() + " " + auto + " is not 'true' or 'false'");
        }
        return answer;
    }

    private int getInstances(int dflt) {
        int instances;
        String inst = this.cli_props.getProperty(IUiOptions.UiOption.Instances.pname());
        if (inst == null) {
            return dflt;
        }
        try {
            instances = Integer.parseInt(inst);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(IUiOptions.UiOption.Instances.pname() + " " + inst + " is not numeric.");
        }
        if (instances <= 0) {
            throw new IllegalArgumentException(IUiOptions.UiOption.Instances.pname() + " " + inst + " must be > 0");
        }
        return instances;
    }

    private void setLinger() {
        String default_linger = DuccPropertiesResolver.get((String)"ducc.sm.default.linger", (String)"5000");
        String linger = this.cli_props.getStringProperty(IUiOptions.UiOption.ServiceLinger.pname(), default_linger);
        try {
            Long.parseLong(linger);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(IUiOptions.UiOption.ServiceLinger.pname() + " is not numeric: " + linger);
        }
    }

    private void enrichPropertiesForDebug(IUiOptions.UiOption verb) {
        String debug_port = this.cli_props.getProperty(IUiOptions.UiOption.ProcessDebug.pname());
        String debug_host = this.host_address;
        if (debug_port == null) {
            return;
        }
        if (debug_port.equals("off")) {
            if (verb != IUiOptions.UiOption.Modify) {
                System.out.println("Note: 'process_debug = off' removed; 'off' is valid only for --modify");
                this.cli_props.remove((Object)IUiOptions.UiOption.ProcessDebug.pname());
            }
            return;
        }
        if (debug_port.contains(":")) {
            String[] parts = debug_port.split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Error: " + IUiOptions.UiOption.ProcessDebug.pname() + " process_debug must be a single numeric port, or else of the form 'host:port'");
            }
            debug_host = parts[0];
            debug_port = parts[1];
        }
        try {
            Integer.parseInt(debug_port);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid debug port specified, not numeric: " + debug_port);
        }
        this.cli_props.setProperty(IUiOptions.UiOption.ProcessDebug.pname(), debug_host + ":" + debug_port);
    }

    private String extractEndpoint(String jvmargs, String classpath) {
        String dd = this.cli_props.getStringProperty(IUiOptions.UiOption.ProcessDD.pname());
        String working_dir = this.cli_props.getStringProperty(IUiOptions.UiOption.WorkingDirectory.pname());
        this.endpoint = DuccUiUtilities.getEndpoint(working_dir, dd, jvmargs, classpath);
        if (this.debug) {
            System.out.println("DD service endpoint resolves to " + this.endpoint);
        }
        return this.endpoint;
    }

    private void discardOptions(IUiOptions.UiOption[] ignored_options, String type) {
        for (IUiOptions.UiOption opt : ignored_options) {
            if (!this.cli_props.containsKey((Object)opt.pname())) continue;
            this.message("WARNING - Option --" + opt.pname() + " is ignored for " + type + " services");
            this.cli_props.remove((Object)opt.pname());
        }
    }

    public IUiOptions.UiOption[] getModifyOptions() {
        return this.modify_options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply register(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.registration_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        this.setLinger();
        String endpoint = this.cli_props.getStringProperty(IUiOptions.UiOption.ServiceRequestEndpoint.pname(), null);
        if (endpoint == null || endpoint.startsWith(IService.ServiceType.UimaAs.decode())) {
            String uimaDD = this.cli_props.getStringProperty(IUiOptions.UiOption.ProcessDD.pname(), null);
            if (uimaDD == null) {
                throw new IllegalArgumentException("Option --" + IUiOptions.UiOption.ProcessDD.pname() + " is required for UIMA-AS services");
            }
            this.discardOptions(this.custom_only_options, IService.ServiceType.UimaAs.decode());
            if (!this.cli_props.containsKey((Object)IUiOptions.UiOption.ServicePingClass.pname())) {
                this.discardOptions(this.pinger_only_options, "pinger-less UIMA-AS");
            }
            String jvmarg_string = this.cli_props.getProperty(IUiOptions.UiOption.ProcessJvmArgs.pname());
            String classpath_string = this.cli_props.getProperty(IUiOptions.UiOption.Classpath.pname());
            String inferred_endpoint = this.extractEndpoint(jvmarg_string, classpath_string);
            if (endpoint == null) {
                endpoint = inferred_endpoint;
            } else if (!inferred_endpoint.equals(endpoint = DuccUiUtilities.check_service_dependencies(null, endpoint))) {
                throw new IllegalArgumentException("Specified endpoint does not match endpoint extracted from UIMA DD\n --service_request_endpoint: " + endpoint + "\n                  extracted: " + inferred_endpoint);
            }
            this.cli_props.setProperty(IUiOptions.UiOption.ServiceRequestEndpoint.pname(), endpoint);
            String key_cp = IUiOptions.UiOption.Classpath.pname();
            if (!this.cli_props.containsKey((Object)key_cp)) {
                this.cli_props.setProperty(key_cp, System.getProperty("java.class.path"));
            }
            this.enrichPropertiesForDebug(IUiOptions.UiOption.Register);
            this.check_heap_size(IUiOptions.UiOption.ProcessJvmArgs.pname());
        } else if (endpoint.startsWith(IService.ServiceType.Custom.decode())) {
            if (!this.cli_props.containsKey((Object)IUiOptions.UiOption.ServicePingClass.pname())) {
                throw new IllegalArgumentException("Option --service_ping_class is required for CUSTOM services");
            }
            this.discardOptions(this.uimaas_only_options, IService.ServiceType.Custom.decode());
            String key_cp = IUiOptions.UiOption.ServicePingClasspath.pname();
            if (!this.cli_props.containsKey((Object)key_cp)) {
                this.cli_props.setProperty(key_cp, System.getProperty("java.class.path"));
            }
            this.check_heap_size(IUiOptions.UiOption.ProcessExecutableArgs.pname());
        } else {
            throw new IllegalArgumentException("Invalid service endpoint: " + endpoint);
        }
        String scheduling_class = this.cli_props.getProperty(IUiOptions.UiOption.SchedulingClass.pname());
        boolean isPreemptableClass = false;
        try {
            DuccSchedulerClasses duccSchedulerClasses = DuccSchedulerClasses.getInstance();
            if (scheduling_class != null) {
                isPreemptableClass = duccSchedulerClasses.isPreemptable(scheduling_class);
            } else {
                this.cli_props.setProperty(IUiOptions.UiOption.SchedulingClass.pname(), duccSchedulerClasses.getDebugClassDefaultName());
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Error in DUCC configuration files - see administrator", (Throwable)e);
        }
        if (isPreemptableClass) {
            throw new IllegalArgumentException("Invalid pre-emptable scheduling class: " + scheduling_class);
        }
        if (!this.check_service_dependencies(endpoint)) {
            throw new IllegalArgumentException("Invalid service dependencies");
        }
        int instances = this.cli_props.getIntProperty(IUiOptions.UiOption.Instances.pname(), 1);
        IService.Trinary autostart = this.getAutostart();
        String user = (String)this.cli_props.remove((Object)IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])this.cli_props.remove((Object)IUiOptions.UiOption.Signature.pname());
        this.cli_props.remove((Object)IUiOptions.UiOption.SubmitPid.pname());
        this.cli_props.remove((Object)IUiOptions.UiOption.Register.pname());
        this.cli_props.remove((Object)IUiOptions.UiOption.Instances.pname());
        this.cli_props.remove((Object)IUiOptions.UiOption.Autostart.pname());
        ServiceRegisterEvent ev = new ServiceRegisterEvent(user, instances, autostart, endpoint, this.cli_props, auth_block, CliVersion.getVersion());
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply unregister(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.unregister_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Unregister);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        boolean asAdministrator = dp.containsKey((Object)IUiOptions.UiOption.RoleAdministrator.pname());
        ServiceUnregisterEvent ev = new ServiceUnregisterEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block, CliVersion.getVersion());
        ev.setAdministrative(asAdministrator);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply start(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.start_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Start);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        boolean asAdministrator = dp.containsKey((Object)IUiOptions.UiOption.RoleAdministrator.pname());
        ServiceStartEvent ev = new ServiceStartEvent(user, ((Integer)id.first()).intValue(), (String)id.second(), auth_block, CliVersion.getVersion());
        ev.setAdministrative(asAdministrator);
        int instances = this.getInstances(-1);
        ev.setInstances(instances);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply stop(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.stop_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Stop);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        boolean asAdministrator = dp.containsKey((Object)IUiOptions.UiOption.RoleAdministrator.pname());
        ServiceStopEvent ev = new ServiceStopEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block, CliVersion.getVersion());
        ev.setAdministrative(asAdministrator);
        int instances = this.getInstances(-1);
        ev.setInstances(instances);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply modify(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.inhibitDefaults();
        this.init(this.getClass().getName(), this.modify_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        this.enrichPropertiesForDebug(IUiOptions.UiOption.Modify);
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Modify);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        boolean asAdministrator = dp.containsKey((Object)IUiOptions.UiOption.RoleAdministrator.pname());
        dp.remove((Object)IUiOptions.UiOption.RoleAdministrator.pname());
        ServiceModifyEvent ev = new ServiceModifyEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), (DuccProperties)dp, auth_block, CliVersion.getVersion());
        ev.setAdministrative(asAdministrator);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply modifyX(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.modify_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Modify);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        SpecificationProperties mods = new SpecificationProperties();
        ServiceModifyEvent ev = new ServiceModifyEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), (DuccProperties)mods, auth_block, CliVersion.getVersion());
        int instances = this.getInstances(-1);
        IService.Trinary autostart = this.getAutostart();
        String pingArguments = this.cli_props.getProperty(IUiOptions.UiOption.ServicePingArguments.pname());
        String pingClass = this.cli_props.getProperty(IUiOptions.UiOption.ServicePingClass.pname());
        String pingClasspath = this.cli_props.getProperty(IUiOptions.UiOption.ServicePingClasspath.pname());
        String pingJvmArgs = this.cli_props.getProperty(IUiOptions.UiOption.ServicePingJvmArgs.pname());
        String pingTimeout = this.cli_props.getProperty(IUiOptions.UiOption.ServicePingTimeout.pname());
        String pingDoLog = this.cli_props.getProperty(IUiOptions.UiOption.ServicePingDoLog.pname());
        if (instances > 0) {
            mods.setProperty("instances", Integer.toString(instances));
        }
        switch (autostart) {
            case True: {
                mods.setProperty("autostart", "true");
                break;
            }
            case False: {
                mods.setProperty("autostart", "false");
                break;
            }
        }
        if (pingArguments != null) {
            mods.setProperty("service_ping_arguments", pingArguments);
        }
        if (pingClass != null) {
            mods.setProperty("service_ping_class", pingClass);
        }
        if (pingClasspath != null) {
            mods.setProperty("service_ping_classpath", pingClasspath);
        }
        if (pingJvmArgs != null) {
            mods.setProperty("service_ping_jvm_args", pingJvmArgs);
        }
        if (pingTimeout != null) {
            mods.setProperty("service_ping_timeout", pingTimeout);
        }
        if (pingDoLog != null) {
            mods.setProperty("service_ping_dolog", pingDoLog);
        }
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply query(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.query_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        Pair<Integer, String> id = null;
        String sid = this.cli_props.getProperty(IUiOptions.UiOption.Query.pname()).trim();
        id = sid == null || sid.equals("") ? new Pair<Integer, String>((Object)-1, null) : this.getId(IUiOptions.UiOption.Query);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        ServiceQueryEvent ev = new ServiceQueryEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block, CliVersion.getVersion());
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply observeReferences(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.observe_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Observe);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        boolean asAdministrator = dp.containsKey((Object)IUiOptions.UiOption.RoleAdministrator.pname());
        ServiceObserveEvent ev = new ServiceObserveEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block, CliVersion.getVersion());
        ev.setAdministrative(asAdministrator);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply ignoreReferences(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.ignore_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Ignore);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        boolean asAdministrator = dp.containsKey((Object)IUiOptions.UiOption.RoleAdministrator.pname());
        ServiceIgnoreEvent ev = new ServiceIgnoreEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block, CliVersion.getVersion());
        ev.setAdministrative(asAdministrator);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply enable(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.enable_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Enable);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        boolean asAdministrator = dp.containsKey((Object)IUiOptions.UiOption.RoleAdministrator.pname());
        ServiceEnableEvent ev = new ServiceEnableEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block, CliVersion.getVersion());
        ev.setAdministrative(asAdministrator);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceReply disable(String[] args) throws Exception {
        SpecificationProperties dp = new SpecificationProperties();
        this.init(this.getClass().getName(), this.disable_options, args, null, (DuccProperties)dp, this.callback, target_daemon);
        Pair<Integer, String> id = this.getId(IUiOptions.UiOption.Disable);
        String user = dp.getProperty(IUiOptions.UiOption.User.pname());
        byte[] auth_block = (byte[])dp.get((Object)IUiOptions.UiOption.Signature.pname());
        boolean asAdministrator = dp.containsKey((Object)IUiOptions.UiOption.RoleAdministrator.pname());
        ServiceDisableEvent ev = new ServiceDisableEvent(user, (long)((Integer)id.first()).intValue(), (String)id.second(), auth_block, CliVersion.getVersion());
        ev.setAdministrative(asAdministrator);
        try {
            IServiceReply iServiceReply = (IServiceReply)this.dispatcher.dispatchAndWaitForDuccReply((DuccEvent)ev);
            return iServiceReply;
        }
        finally {
            this.dispatcher.close();
        }
    }

    void help() {
        CommandLine cl = new CommandLine(null, this.registration_options);
        System.out.println(cl.formatHelp("--------------- Register Options -------------"));
        cl = new CommandLine(null, this.unregister_options);
        System.out.println(cl.formatHelp("\n\n------------- Unregister Options ------------------"));
        cl = new CommandLine(null, this.start_options);
        System.out.println(cl.formatHelp("\n\n------------- Start Options ------------------"));
        cl = new CommandLine(null, this.stop_options);
        System.out.println(cl.formatHelp("\n\n------------- Stop Options ------------------"));
        cl = new CommandLine(null, this.modify_options);
        System.out.println(cl.formatHelp("\n\n------------- Modify Options ------------------"));
        cl = new CommandLine(null, this.query_options);
        System.out.println(cl.formatHelp("\n\n------------- Query Options ------------------"));
        System.exit(1);
    }

    @Override
    public boolean execute() {
        return false;
    }

    static boolean format_reply(IUiOptions.UiOption verb, IServiceReply reply) {
        String ep = reply.getEndpoint() == null ? "N/A" : reply.getEndpoint();
        String id = reply.getId() != -1L ? " ID[" + String.valueOf(reply.getId()) + "]" : "";
        boolean rc = reply.getReturnCode();
        String result = rc ? " succeeded - " : " failed - ";
        String msg = "Service " + verb + result + reply.getMessage() + " - " + ep + id;
        switch (verb) {
            case Register: 
            case Unregister: 
            case Start: 
            case Stop: 
            case Modify: 
            case Disable: 
            case Enable: 
            case Ignore: 
            case Observe: {
                System.out.println(msg);
                break;
            }
            case Query: {
                if (rc) {
                    System.out.println(reply.toString());
                    break;
                }
                System.out.println(msg);
                break;
            }
            default: {
                System.out.println(msg);
            }
        }
        return rc;
    }

    static boolean Register(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.register(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Register, reply);
    }

    static boolean Unregister(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.unregister(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Unregister, reply);
    }

    static boolean Start(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.start(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Start, reply);
    }

    static boolean Stop(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.stop(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Stop, reply);
    }

    static boolean Modify(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.modify(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Modify, reply);
    }

    static boolean Enable(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.enable(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Enable, reply);
    }

    static boolean Disable(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.disable(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Disable, reply);
    }

    static boolean ObserveReferences(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.observeReferences(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Observe, reply);
    }

    static boolean IgnoreReferences(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.ignoreReferences(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Ignore, reply);
    }

    static boolean Query(String[] args) throws Exception {
        DuccServiceApi api = new DuccServiceApi(null);
        IServiceReply reply = api.query(args);
        return DuccServiceApi.format_reply(IUiOptions.UiOption.Query, reply);
    }

    static void Help() {
        DuccServiceApi api = new DuccServiceApi(null);
        api.help();
        System.exit(1);
    }

    static IUiOptions.UiOption getVerb(String[] args) {
        IUiOptions.UiOption[] verbs = new IUiOptions.UiOption[]{IUiOptions.UiOption.Register, IUiOptions.UiOption.Modify, IUiOptions.UiOption.Start, IUiOptions.UiOption.Stop, IUiOptions.UiOption.Query, IUiOptions.UiOption.Unregister, IUiOptions.UiOption.Observe, IUiOptions.UiOption.Ignore, IUiOptions.UiOption.Enable, IUiOptions.UiOption.Disable};
        ArrayList<IUiOptions.UiOption> check = new ArrayList<IUiOptions.UiOption>();
        IUiOptions.UiOption reply = IUiOptions.UiOption.Help;
        for (String s : args) {
            if (!s.startsWith("--")) continue;
            if ((s = s.substring(2)).equals("help")) {
                DuccServiceApi.Help();
            }
            for (IUiOptions.UiOption v : verbs) {
                if (!s.equals(v.pname())) continue;
                reply = v;
                check.add(v);
            }
        }
        if (check.size() > 1) {
            String msg = "";
            for (IUiOptions.UiOption o : check) {
                msg = msg + " " + o;
            }
            throw new IllegalArgumentException("Duplicate service actions: " + msg);
        }
        return reply;
    }

    public static void main(String[] args) {
        boolean rc = false;
        try {
            switch (DuccServiceApi.getVerb(args)) {
                case Register: {
                    rc = DuccServiceApi.Register(args);
                    break;
                }
                case Unregister: {
                    rc = DuccServiceApi.Unregister(args);
                    break;
                }
                case Start: {
                    rc = DuccServiceApi.Start(args);
                    break;
                }
                case Stop: {
                    rc = DuccServiceApi.Stop(args);
                    break;
                }
                case Observe: {
                    rc = DuccServiceApi.ObserveReferences(args);
                    break;
                }
                case Ignore: {
                    rc = DuccServiceApi.IgnoreReferences(args);
                    break;
                }
                case Enable: {
                    rc = DuccServiceApi.Enable(args);
                    break;
                }
                case Disable: {
                    rc = DuccServiceApi.Disable(args);
                    break;
                }
                case Modify: {
                    rc = DuccServiceApi.Modify(args);
                    break;
                }
                case Query: {
                    rc = DuccServiceApi.Query(args);
                    break;
                }
                default: {
                    System.out.println("Missing service action (register, unregister, start, stop, modify, observe_refrences, ignore_references, enable, disable, or query)");
                    System.exit(1);
                    break;
                }
            }
        }
        catch (Throwable e) {
            System.out.println("Service call failed: " + e);
            Throwable t = e;
            while ((t = t.getCause()) != null) {
                System.out.println("  ... " + t);
            }
            for (String arg : args) {
                if (!arg.equals("--debug")) continue;
                e.printStackTrace();
                break;
            }
            System.exit(1);
        }
        System.exit(rc ? 0 : 1);
    }
}

