/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ping;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.client.UimaASProcessStatus;
import org.apache.uima.aae.client.UimaAsBaseCallbackListener;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngine_impl;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.ServiceStatistics;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.common.TcpStreamHandler;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.sm.UimaAsServiceMonitor;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public class SamplePing
extends AServicePing {
    String ep;
    String qname;
    String broker;
    int meta_timeout = 5000;
    String broker_host;
    int broker_jmx_port = 1099;
    UimaAsServiceMonitor monitor;
    String nodeIp;
    String pid;
    boolean gmfail = false;
    boolean fast_shrink = true;
    int additions = 0;
    Long[] deletions = null;
    int min_instances = 0;
    int max_instances = 10;
    int max_growth = 5;
    double goal = 2.0;
    int cursor = 0;
    int expansion_period;
    int window_size = this.expansion_period = 5;
    int[] expansion_window;
    int[] deletion_window;

    public void init(String args, String ep) throws Exception {
        String methodName = "init";
        this.ep = ep;
        this.doLog(methodName, new Object[]{"Ping.init(" + args + ", " + ep + " start."});
        int ndx = ep.indexOf(":");
        ep = ep.substring(ndx + 1);
        ndx = ep.indexOf(":");
        this.qname = ep.substring(0, ndx).trim();
        this.broker = ep.substring(ndx + 1).trim();
        URL url = null;
        try {
            url = new URL(null, this.broker, (URLStreamHandler)new TcpStreamHandler());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid broker URL: " + this.broker);
        }
        this.broker_host = url.getHost();
        UIMAFramework.getLogger(BaseUIMAAsynchronousEngineCommon_impl.class).setLevel(Level.OFF);
        UIMAFramework.getLogger(BaseUIMAAsynchronousEngine_impl.class).setLevel(Level.OFF);
        UIMAFramework.getLogger().setLevel(Level.INFO);
        if (args != null) {
            String[] as = args.split(",");
            StringWriter sw = new StringWriter();
            for (String s : as) {
                sw.write(s + "\n");
            }
            StringReader sr = new StringReader(sw.toString());
            DuccProperties props = new DuccProperties();
            try {
                props.load((Reader)sr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.meta_timeout = props.getIntProperty("meta-timeout", this.meta_timeout);
            this.broker_jmx_port = props.getIntProperty("broker-jmx-port", this.broker_jmx_port);
            this.expansion_period = props.getIntProperty("window", this.expansion_period);
            this.min_instances = props.getIntProperty("min", this.min_instances);
            this.max_instances = props.getIntProperty("max", this.max_instances);
            this.max_growth = props.getIntProperty("max-growth", this.max_growth);
            this.fast_shrink = props.getBooleanProperty("fast-shrink", true);
            this.goal = props.getDoubleProperty("goal", this.goal);
        }
        double calls_per_minute = 60000.0 / (double)this.monitor_rate;
        this.window_size = (int)((double)this.expansion_period * calls_per_minute);
        this.expansion_window = new int[this.window_size];
        this.deletion_window = new int[this.window_size];
        this.doLog("<ctr>", new Object[]{"INIT: meta-timeout", this.meta_timeout, "broker-host", this.broker_host, "broker-jmx-port", this.broker_jmx_port, "monitor-window", this.expansion_period, "window-size", this.window_size, "monitor rate", this.monitor_rate, "max-instances", this.max_instances, "min-instances", this.min_instances, "max-growth", this.max_growth, "goal", this.goal, "fast-shrink", this.fast_shrink});
        this.monitor = new UimaAsServiceMonitor(this.qname, this.broker_host, this.broker_jmx_port);
        this.monitor.resetStatistics();
    }

    public void stop() {
        String methodName = "stop";
        if (this.monitor != null) {
            this.monitor.stop();
        }
        this.doLog(methodName, new Object[]{"------------ Stop signal arrives, pinger exits."});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IServiceStatistics getStatistics() {
        ServiceStatistics statistics;
        block12: {
            String methodName = "getStatistics";
            statistics = new ServiceStatistics(false, false, "<NA>");
            this.nodeIp = "N/A";
            this.pid = "N/A";
            try {
                this.monitor.collect();
                statistics.setHealthy(true);
            }
            catch (Throwable t) {
                statistics.setHealthy(false);
                this.monitor.setJmxFailure(t.getMessage());
            }
            BaseUIMAAsynchronousEngine_impl uimaAsEngine = new BaseUIMAAsynchronousEngine_impl();
            UimaCbListener listener = new UimaCbListener();
            uimaAsEngine.addStatusCallbackListener((UimaAsBaseCallbackListener)listener);
            HashMap<String, Object> appCtx = new HashMap<String, Object>();
            appCtx.put("ServerURI", this.broker);
            appCtx.put("Endpoint", this.qname);
            appCtx.put("GetMetaTimeout", this.meta_timeout);
            uimaAsEngine.initialize(appCtx);
            statistics.setAlive(true);
            statistics.setHealthy(statistics.isHealthy());
            listener.ok();
            try {
                uimaAsEngine.stop();
            }
            catch (Throwable e) {
                this.doLog(methodName, new Object[]{"Exception on UIMA-AS connection stop:" + e.toString()});
            }
            break block12;
            catch (ResourceInitializationException e) {
                try {
                    listener.timeout();
                    this.doLog(methodName, new Object[]{"Cannot issue getMeta to: " + this.qname + ":" + this.broker});
                    statistics.setHealthy(false);
                    statistics.setAlive(false);
                }
                catch (Throwable throwable) {
                    try {
                        uimaAsEngine.stop();
                    }
                    catch (Throwable e2) {
                        this.doLog(methodName, new Object[]{"Exception on UIMA-AS connection stop:" + e2.toString()});
                    }
                    throw throwable;
                }
                try {
                    uimaAsEngine.stop();
                }
                catch (Throwable e3) {
                    this.doLog(methodName, new Object[]{"Exception on UIMA-AS connection stop:" + e3.toString()});
                }
            }
        }
        this.monitor.setSource(this.nodeIp, this.pid, this.gmfail);
        statistics.setInfo(this.monitor.format());
        this.calculateNewDeployment((IServiceStatistics)statistics);
        return statistics;
    }

    public long getLastUse() {
        return this.last_use;
    }

    void calculateNewDeployment(IServiceStatistics stats) {
        String methodName = "calculateNewDeployment";
        double eT = this.monitor.getEnqueueTime();
        long Q = this.monitor.getQueueSize();
        long cc = this.monitor.getConsumerCount();
        long pc = this.monitor.getProducerCount();
        Long[] instances = (Long[])this.smState.get("all-instances");
        int ninst = instances.length;
        Long[] act_instances = (Long[])this.smState.get("active-instances");
        int active = act_instances.length;
        if (pc > 0L) {
            this.last_use = System.currentTimeMillis();
        }
        int nthreads = (int)(cc / (long)ninst) - 1;
        this.doLog(methodName, new Object[]{stats.getInfo()});
        this.additions = 0;
        this.deletions = null;
        int new_ni = 0;
        if (Q == 0L) {
            if (pc != 0L && !this.fast_shrink) {
                this.doLog(methodName, new Object[]{"Inhibit shrinkage because pc =", pc, "Q =", Q});
                this.deletion_window[this.cursor] = 0;
            } else {
                this.deletion_window[this.cursor] = 1;
            }
            this.expansion_window[this.cursor] = 0;
        } else {
            double Ti = eT / (double)Q * (double)active;
            double Tt = Ti * (double)nthreads;
            double g = Tt * this.goal;
            double r = eT / g;
            this.doLog(methodName, new Object[]{"eT", eT, "Q", Q, "cc", cc, "Ti", Ti, "Tt", Tt, "g", g, "r", r, "active", active, "ninstances", ninst, "max_instances", this.max_instances});
            if (r > 1.0) {
                new_ni = (int)Math.ceil((double)active * r);
                new_ni = Math.max(new_ni - ninst, 0);
                new_ni = Math.min(new_ni, this.max_instances);
                if ((new_ni = Math.min(new_ni, this.max_growth)) > 0) {
                    this.doLog(methodName, new Object[]{"Expand, new_n1:", new_ni});
                    this.expansion_window[this.cursor] = 1;
                } else {
                    this.doLog(methodName, new Object[]{"Don't expand, new_n1:", new_ni});
                    this.expansion_window[this.cursor] = 0;
                }
            } else {
                this.doLog(methodName, new Object[]{"Don't expand, r < 1.0:", r});
                this.expansion_window[this.cursor] = 0;
            }
            if (r < 0.5) {
                if (pc != 0L && !this.fast_shrink) {
                    this.doLog(methodName, new Object[]{"Inhibit shrinkage because pc =", pc, "r=", r});
                    this.deletion_window[this.cursor] = 0;
                } else {
                    this.doLog(methodName, new Object[]{"Allow shrinkage: r =", r, "pc =", pc});
                    this.deletion_window[this.cursor] = 1;
                }
            } else {
                this.deletion_window[this.cursor] = 0;
            }
        }
        this.doLog(methodName, new Object[]{"Expansion window:", Arrays.toString(this.expansion_window)});
        this.doLog(methodName, new Object[]{"Deletion  window:", Arrays.toString(this.deletion_window)});
        int etot = 0;
        int dtot = 0;
        for (int i = 0; i < this.window_size; ++i) {
            etot += this.expansion_window[i];
            dtot += this.deletion_window[i];
        }
        if (etot == this.expansion_window.length && new_ni > 0) {
            this.additions = new_ni;
            this.deletions = null;
            if (ninst > active) {
                this.additions = 0;
            } else {
                this.expansion_window[this.cursor] = 0;
            }
        }
        if (dtot == this.deletion_window.length) {
            this.additions = 0;
            if (ninst > this.min_instances) {
                this.deletions = new Long[1];
                this.deletions[0] = act_instances[act_instances.length - 1];
                this.doLog(methodName, new Object[]{"Deletions:", this.deletions[0]});
                this.deletion_window[this.cursor] = 0;
            }
        }
        this.doLog(methodName, new Object[]{"Cursor before:", this.cursor, "window_size", this.window_size});
        ++this.cursor;
        this.cursor %= this.window_size;
        this.doLog(methodName, new Object[]{"Cursor after:", this.cursor});
    }

    public int getAdditions() {
        return this.additions;
    }

    public Long[] getDeletions() {
        return this.deletions;
    }

    class UimaCbListener
    extends UimaAsBaseCallbackListener {
        public void ok() {
            SamplePing.this.gmfail = false;
        }

        public void timeout() {
            String methodName = "UimaAsPing:get-meta";
            SamplePing.this.doLog(methodName, new Object[]{null, "Get-Meta timeout from ", SamplePing.this.nodeIp, "PID", SamplePing.this.pid});
            SamplePing.this.gmfail = true;
        }

        public void onBeforeMessageSend(UimaASProcessStatus status) {
        }

        public void onBeforeProcessMeta(String IP, String p) {
            SamplePing.this.pid = p;
            SamplePing.this.nodeIp = IP;
        }

        public void initializationComplete(EntityProcessStatus aStatus) {
        }

        public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
        }

        public void collectionProcessComplete(EntityProcessStatus aStatus) {
        }
    }
}

