/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.verifier;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public final class OptionsGroup
implements Serializable {
    private final String name;
    private final Set<String> options;

    public OptionsGroup(String name) {
        this.name = name;
        this.options = new HashSet<String>();
    }

    public OptionsGroup(String name, Collection<String> options) {
        this.name = name;
        this.options = new LinkedHashSet<String>(options);
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public OptionsGroup option(String option) {
        this.options.add(option);
        return this;
    }

    public OptionsGroup options(String ... options) {
        for (String option : options) {
            this.addOption(option);
        }
        return this;
    }

    public static OptionsGroup withName(String name) {
        return new OptionsGroup(name);
    }

    public static OptionsGroup withName(Enum<?> enumItem) {
        return new OptionsGroup(enumItem.name());
    }

    public static OptionsGroup withNameAndOptions(String name, String ... options) {
        return new OptionsGroup(name, Arrays.asList(options));
    }
}

