/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.json.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import javax.naming.OperationNotSupportedException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JsonContentHandlerJacksonWrapper
implements ContentHandler {
    private static final char[] BLANKS = new char[80];
    public static final String SYSTEM_LINE_FEED;
    private final boolean isFormattedOutput;
    private final JsonGenerator jg;
    private boolean doNl;
    private final UimaJsonPrettyPrinter uimaPrettyPrinter;
    private static final FixedSpaceIndenterWithNesting FSIWN;

    public boolean isFormattedOutput() {
        return this.isFormattedOutput;
    }

    public JsonGenerator getJsonGenerator() {
        return this.jg;
    }

    private static JsonGenerator createGenerator(JsonFactory f, Object o) throws SAXException {
        try {
            if (o instanceof Writer) {
                return f.createGenerator((Writer)o);
            }
            if (o instanceof OutputStream) {
                return f.createGenerator((OutputStream)o);
            }
            if (o instanceof File) {
                return f.createGenerator((File)o, JsonEncoding.UTF8);
            }
            throw new RuntimeException(new OperationNotSupportedException(String.format("Object must be a Writer, OutputStream, or File, but was of class %s", o.getClass().getName())));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public JsonContentHandlerJacksonWrapper(Object destination) throws SAXException {
        this(new JsonFactory(), destination);
    }

    public JsonContentHandlerJacksonWrapper(JsonFactory jsonFactory, Object o) throws SAXException {
        this(JsonContentHandlerJacksonWrapper.createGenerator(jsonFactory, o));
    }

    public JsonContentHandlerJacksonWrapper(Object o, boolean isFormattedOutput) throws SAXException {
        this(new JsonFactory(), o, isFormattedOutput);
    }

    public JsonContentHandlerJacksonWrapper(JsonFactory jsonFactory, Object o, boolean isFormattedOutput) throws SAXException {
        this(JsonContentHandlerJacksonWrapper.createGenerator(null == jsonFactory ? new JsonFactory() : jsonFactory, o), isFormattedOutput);
    }

    public JsonContentHandlerJacksonWrapper(JsonGenerator jsonGenerator) {
        this(jsonGenerator, false);
    }

    public JsonContentHandlerJacksonWrapper(JsonGenerator jsonGenerator, boolean isFormattedOutput) {
        this.jg = jsonGenerator;
        this.isFormattedOutput = isFormattedOutput;
        if (isFormattedOutput) {
            this.uimaPrettyPrinter = new UimaJsonPrettyPrinter();
            this.uimaPrettyPrinter.withoutSpacesInObjectEntries();
            this.jg.setPrettyPrinter((PrettyPrinter)this.uimaPrettyPrinter);
        } else {
            this.uimaPrettyPrinter = null;
        }
    }

    public void writeNlJustBeforeNext() {
        this.doNl = true;
    }

    private void outputAttrsAsProperties(Attributes atts) {
        if (null != atts) {
            try {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String val = atts.getValue(i);
                    if (val == null || val.equals("")) continue;
                    String prefix = atts.getQName(i);
                    String attType = atts.getType(i);
                    if ("array".equals(atts.getType(i))) {
                        this.jg.writeArrayFieldStart(prefix);
                        this.jg.writeRawValue(val);
                        this.jg.writeEndArray();
                        continue;
                    }
                    if ("string".equals(attType)) {
                        this.jg.writeStringField(prefix, val);
                        continue;
                    }
                    if ("boolean".equals(attType)) {
                        this.jg.writeBooleanField(prefix, val.equals("true"));
                        continue;
                    }
                    this.jg.writeFieldName(prefix);
                    this.jg.writeRawValue(val);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void unsupported() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.unsupported();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.unsupported();
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.unsupported();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.unsupported();
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.unsupported();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (qName != null) {
                this.jg.writeStartObject();
                this.jg.writeFieldName(qName);
                this.jg.writeStartObject();
            }
            this.outputAttrsAsProperties(atts);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (null != qName) {
                this.jg.writeEndObject();
            }
            this.jg.writeEndObject();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void withoutNl() {
        if (this.isFormattedOutput) {
            this.uimaPrettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)FSIWN);
            this.uimaPrettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)FSIWN);
        }
    }

    public void withNl() {
        if (this.isFormattedOutput) {
            this.uimaPrettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)DefaultPrettyPrinter.Lf2SpacesIndenter.instance);
        }
    }

    static {
        Arrays.fill(BLANKS, ' ');
        String lf = System.getProperty("line.separator");
        SYSTEM_LINE_FEED = lf == null ? "\n" : lf;
        FSIWN = new FixedSpaceIndenterWithNesting();
    }

    private static class FixedSpaceIndenterWithNesting
    extends DefaultPrettyPrinter.FixedSpaceIndenter {
        private static final long serialVersionUID = 1L;

        private FixedSpaceIndenterWithNesting() {
        }

        public boolean isInline() {
            return false;
        }
    }

    private class UimaJsonPrettyPrinter
    extends DefaultPrettyPrinter
    implements PrettyPrinter {
        private static final long serialVersionUID = 1L;

        private UimaJsonPrettyPrinter() {
        }

        public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            super.writeObjectEntrySeparator(jg);
            this.maybeOutputNlOrBlank(jg);
        }

        public void writeArrayValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            super.writeArrayValueSeparator(jg);
            this.maybeOutputNlOrBlank(jg);
        }

        public void beforeArrayValues(JsonGenerator jg) throws IOException, JsonGenerationException {
            this.maybeOutputNl(jg);
        }

        public void beforeObjectEntries(JsonGenerator jg) throws IOException, JsonGenerationException {
            this.maybeOutputNl(jg);
        }

        private void maybeOutputNl(JsonGenerator jg) throws IOException {
            if (JsonContentHandlerJacksonWrapper.this.doNl) {
                this.maybeOutputNlIndent();
                JsonContentHandlerJacksonWrapper.this.doNl = false;
            }
        }

        private void maybeOutputNlOrBlank(JsonGenerator jg) throws IOException {
            if (JsonContentHandlerJacksonWrapper.this.doNl) {
                this.maybeOutputNl(jg);
            } else {
                jg.writeRaw(' ');
            }
        }

        private void maybeOutputNlIndent() throws IOException {
            if (JsonContentHandlerJacksonWrapper.this.isFormattedOutput) {
                JsonContentHandlerJacksonWrapper.this.jg.writeRaw(SYSTEM_LINE_FEED);
                JsonContentHandlerJacksonWrapper.this.jg.writeRaw(BLANKS, 0, Math.min(BLANKS.length, this._nesting << 1));
            }
        }
    }
}

