/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class InetHelper {
    private static DuccLogger duccLogger = DuccLogger.getLogger(InetHelper.class);
    private static DuccId jobid = null;

    public static String getCanonicalHostName() {
        String methodName = "getCanonicalHostName";
        String hostname = "localhost";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostname = inetAddress.getCanonicalHostName();
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, e, new Object[0]);
        }
        return hostname;
    }

    public static String getShortHostName() {
        String methodName = "getShortHostName";
        String hostname = "localhost";
        try {
            String canonicalHostName = InetHelper.getCanonicalHostName();
            if (canonicalHostName != null) {
                hostname = canonicalHostName;
                if (canonicalHostName.contains(".")) {
                    hostname = canonicalHostName.split("\\.")[0];
                }
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, e, new Object[0]);
        }
        return hostname;
    }

    public static String getHostName() {
        return InetHelper.getShortHostName();
    }

    public static String[] getIP(String[] hostList) {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            if (hostList != null) {
                for (String hostName : hostList) {
                    InetAddress inetAddress = InetAddress.getByName(hostName);
                    StringBuffer sb = new StringBuffer();
                    byte[] byteAddress = inetAddress.getAddress();
                    if (byteAddress == null) continue;
                    for (int i = 0; i < byteAddress.length; ++i) {
                        if (i > 0) {
                            sb.append(".");
                        }
                        sb.append(byteAddress[i] & 0xFF);
                    }
                    ipList.add(sb.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ipList.toArray(new String[0]);
    }
}

