/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.uima.ducc.common.IIdentity;
import org.apache.uima.ducc.common.Identity;
import org.apache.uima.ducc.common.utils.Utils;

public class NodeIdentity
implements Serializable {
    private static final long serialVersionUID = -3725003472985192870L;
    private String name;
    private String ip;
    private String pid;
    private List<IIdentity> nodeIdentities = new ArrayList<IIdentity>();

    public NodeIdentity(String ip, String name) throws Exception {
        this.setName(name);
        this.setIp(ip);
        this.setPid(Utils.getPID());
        this.nodeIdentities.add(new Identity(name, ip));
    }

    public NodeIdentity() throws Exception {
        this.setName(InetAddress.getLocalHost().getCanonicalHostName());
        this.setIp(InetAddress.getLocalHost().getHostAddress());
        this.setPid(Utils.getPID());
        Enumeration<NetworkInterface> netinterfaces = NetworkInterface.getNetworkInterfaces();
        while (netinterfaces.hasMoreElements()) {
            NetworkInterface iface = netinterfaces.nextElement();
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress add = addresses.nextElement();
                this.nodeIdentities.add(new Identity(add.getCanonicalHostName(), add.getHostAddress()));
            }
        }
    }

    private void setPid(String pid) {
        this.pid = pid;
    }

    public String getPid() {
        return this.pid;
    }

    public List<IIdentity> getNodeIdentities() {
        return this.nodeIdentities;
    }

    public String getCanonicalName() {
        return this.name;
    }

    public String getShortName() {
        String canonicalHostName;
        String hostName = canonicalHostName = this.name;
        if (canonicalHostName != null) {
            hostName = canonicalHostName;
            if (canonicalHostName.contains(".")) {
                hostName = canonicalHostName.split("\\.")[0];
            }
        }
        return hostName;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getIp() {
        return this.ip;
    }

    protected void setIp(String ip) {
        this.ip = ip;
    }

    public String toString() {
        return "Name:" + this.name + " IP:" + this.ip;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeIdentity other = (NodeIdentity)obj;
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

