/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Whitespace;

public final class DayTimeDurationValue
extends DurationValue
implements Comparable {
    private DayTimeDurationValue() {
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public DayTimeDurationValue(CharSequence charSequence) throws XPathException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)Whitespace.trimWhitespace(charSequence)).toString(), "-+.PDTHMS", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ("+".equals(string = (String)stringTokenizer.nextElement())) {
                this.badDuration("+ sign not allowed in a duration", charSequence);
            } else if ("-".equals(string)) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!"P".equals(string)) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n2 = 0;
            block9: while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if ("T".equals(string)) {
                    n2 = 4;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDuration("T must be followed by time components", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                }
                int n3 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'D': {
                        if (n2 > 2) {
                            this.badDuration("D is out of sequence", charSequence);
                        }
                        this.days = n3;
                        ++n;
                        n2 = 3;
                        continue block9;
                    }
                    case 'H': {
                        if (n2 != 4) {
                            this.badDuration("H is out of sequence", charSequence);
                        }
                        this.hours = n3;
                        ++n;
                        n2 = 5;
                        continue block9;
                    }
                    case 'M': {
                        if (n2 < 4 || n2 > 5) {
                            this.badDuration("M is out of sequence", charSequence);
                        }
                        this.minutes = n3;
                        ++n;
                        n2 = 6;
                        continue block9;
                    }
                    case '.': {
                        if (n2 < 4 || n2 > 6) {
                            this.badDuration("misplaced decimal point", charSequence);
                        }
                        this.seconds = n3;
                        ++n;
                        n2 = 7;
                        continue block9;
                    }
                    case 'S': {
                        if (n2 < 4 || n2 > 7) {
                            this.badDuration("S is out of sequence", charSequence);
                        }
                        if (n2 == 7) {
                            while (string.length() < 6) {
                                string = string + "0";
                            }
                            if (string.length() > 6) {
                                string = string.substring(0, 6);
                            }
                            this.microseconds = Integer.parseInt(string);
                        } else {
                            this.seconds = n3;
                        }
                        ++n;
                        n2 = 8;
                        continue block9;
                    }
                }
                this.badDuration("misplaced " + c, charSequence);
            }
            if (n == 0) {
                this.badDuration("Duration specifies no components", charSequence);
            }
            this.normalize();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric or out-of-range component", charSequence);
        }
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public DayTimeDurationValue(int n, int n2, int n3, int n4, int n5, int n6) throws ValidationException {
        this.negative = n < 0;
        this.years = 0;
        this.months = 0;
        this.days = n2;
        this.hours = n3;
        this.minutes = n4;
        this.seconds = n5;
        this.microseconds = n6;
        this.normalize();
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public AtomicValue copy(AtomicType atomicType) {
        DayTimeDurationValue dayTimeDurationValue = DayTimeDurationValue.fromMicroseconds(this.getLengthInMicroseconds());
        dayTimeDurationValue.typeLabel = atomicType;
        return dayTimeDurationValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append('P');
        if (this.days != 0) {
            fastStringBuffer.append(this.days + "D");
        }
        if (this.days == 0 || this.hours != 0 || this.minutes != 0 || this.seconds != 0 || this.microseconds != 0) {
            fastStringBuffer.append('T');
        }
        if (this.hours != 0) {
            fastStringBuffer.append(this.hours + "H");
        }
        if (this.minutes != 0) {
            fastStringBuffer.append(this.minutes + "M");
        }
        if (this.seconds != 0 || this.microseconds != 0 || this.days == 0 && this.minutes == 0 && this.hours == 0) {
            if (this.microseconds == 0) {
                fastStringBuffer.append(this.seconds + "S");
            } else {
                long l = this.seconds * 1000000 + this.microseconds;
                String string = l + "";
                if (this.seconds == 0) {
                    string = "0000000" + string;
                    string = string.substring(string.length() - 7);
                }
                fastStringBuffer.append(string.substring(0, string.length() - 6));
                fastStringBuffer.append('.');
                int n = string.length() - 1;
                while (string.charAt(n) == '0') {
                    --n;
                }
                fastStringBuffer.append(string.substring(string.length() - 6, n + 1));
                fastStringBuffer.append('S');
            }
        }
        return fastStringBuffer;
    }

    public void normalize() throws ValidationException {
        long l = this.seconds;
        long l2 = this.minutes;
        long l3 = this.hours;
        long l4 = this.days;
        if (this.microseconds >= 1000000) {
            l += (long)(this.microseconds / 1000000);
            this.microseconds %= 1000000;
        }
        if (this.seconds >= 60) {
            l2 += l / 60L;
            l = (int)(l % 60L);
        }
        if (l2 >= 60L) {
            l3 += l2 / 60L;
            l2 = (int)(l2 % 60L);
        }
        if (l3 >= 24L) {
            if ((l4 += l3 / 24L) > Integer.MAX_VALUE || l4 < Integer.MIN_VALUE) {
                throw new ValidationException("Duration exceeds implementation-defined limits");
            }
            l3 = (int)(l3 % 24L);
        }
        this.days = (int)l4;
        this.hours = (int)l3;
        this.minutes = (int)l2;
        this.seconds = (int)l;
        this.normalizeZeroDuration();
        this.normalized = true;
    }

    public double getLengthInSeconds() {
        double d = this.days;
        d = d * 24.0 + (double)this.hours;
        d = d * 60.0 + (double)this.minutes;
        d = d * 60.0 + (double)this.seconds;
        return this.negative ? -d : (d += (double)this.microseconds / 1000000.0);
    }

    public long getLengthInMilliseconds() {
        long l = this.days;
        l = l * 24L + (long)this.hours;
        l = l * 60L + (long)this.minutes;
        l = l * 60L + (long)this.seconds;
        l = l * 1000L + (long)(this.microseconds / 1000);
        return this.negative ? -l : l;
    }

    public long getLengthInMicroseconds() {
        long l = this.days;
        l = l * 24L + (long)this.hours;
        l = l * 60L + (long)this.minutes;
        l = l * 60L + (long)this.seconds;
        l = l * 1000000L + (long)this.microseconds;
        return this.negative ? -l : l;
    }

    public static DayTimeDurationValue fromSeconds(BigDecimal bigDecimal) throws XPathException {
        DayTimeDurationValue dayTimeDurationValue = new DayTimeDurationValue();
        boolean bl = dayTimeDurationValue.negative = bigDecimal.signum() < 0;
        if (dayTimeDurationValue.negative) {
            bigDecimal = bigDecimal.negate();
        }
        BigDecimal bigDecimal2 = bigDecimal.multiply(DecimalValue.BIG_DECIMAL_ONE_MILLION);
        BigInteger bigInteger = bigDecimal2.toBigInteger();
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BigInteger.valueOf(1000000L));
        long l = bigIntegerArray[0].longValue();
        dayTimeDurationValue.days = (int)(l / 86400L);
        dayTimeDurationValue.seconds = (int)(l % 86400L);
        dayTimeDurationValue.microseconds = bigIntegerArray[1].intValue();
        dayTimeDurationValue.normalize();
        return dayTimeDurationValue;
    }

    public static DayTimeDurationValue fromMilliseconds(long l) throws XPathException {
        DayTimeDurationValue dayTimeDurationValue = new DayTimeDurationValue();
        dayTimeDurationValue.negative = l < 0L;
        l = Math.abs(l);
        long l2 = l / 1000L;
        dayTimeDurationValue.days = (int)(l2 / 86400L);
        dayTimeDurationValue.seconds = (int)(l2 % 86400L);
        dayTimeDurationValue.microseconds = (int)(l % 1000L) * 1000;
        dayTimeDurationValue.normalize();
        return dayTimeDurationValue;
    }

    public static DayTimeDurationValue fromMicroseconds(long l) throws IllegalArgumentException {
        DayTimeDurationValue dayTimeDurationValue = new DayTimeDurationValue();
        dayTimeDurationValue.negative = l < 0L;
        l = Math.abs(l);
        long l2 = l / 1000000L;
        dayTimeDurationValue.days = (int)(l2 / 86400L);
        dayTimeDurationValue.seconds = (int)(l2 % 86400L);
        dayTimeDurationValue.microseconds = (int)(l % 1000000L);
        try {
            dayTimeDurationValue.normalize();
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
        return dayTimeDurationValue;
    }

    public DurationValue multiply(double d) throws XPathException {
        if (Double.isNaN(d)) {
            DynamicError dynamicError = new DynamicError("Cannot multiply/divide a duration by NaN");
            dynamicError.setErrorCode("FOCA0005");
            throw dynamicError;
        }
        double d2 = this.getLengthInMicroseconds();
        double d3 = d * d2;
        if (Double.isInfinite(d3) || Double.isNaN(d3) || d3 > 9.223372036854776E18 || d3 < -9.223372036854776E18) {
            DynamicError dynamicError = new DynamicError("Overflow when multiplying/dividing a duration by a number");
            dynamicError.setErrorCode("FODT0002");
            throw dynamicError;
        }
        try {
            return DayTimeDurationValue.fromMicroseconds((long)d3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getCause() instanceof XPathException) {
                throw (XPathException)illegalArgumentException.getCause();
            }
            DynamicError dynamicError = new DynamicError("Overflow when multiplying/dividing a duration by a number", illegalArgumentException);
            dynamicError.setErrorCode("FODT0002");
            throw dynamicError;
        }
    }

    public DecimalValue divide(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof DayTimeDurationValue) {
            BigDecimal bigDecimal = BigDecimal.valueOf(this.getLengthInMicroseconds());
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((DayTimeDurationValue)durationValue).getLengthInMicroseconds());
            if (bigDecimal2.signum() == 0) {
                DynamicError dynamicError = new DynamicError("Divide by zero (durations)");
                dynamicError.setErrorCode("FOAR0001");
                throw dynamicError;
            }
            return new DecimalValue(bigDecimal.divide(bigDecimal2, 20, 6));
        }
        DynamicError dynamicError = new DynamicError("Cannot divide two durations of different type");
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public DurationValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof DayTimeDurationValue) {
            try {
                return DayTimeDurationValue.fromMicroseconds(this.getLengthInMicroseconds() + ((DayTimeDurationValue)durationValue).getLengthInMicroseconds());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DynamicError dynamicError = new DynamicError("Overflow when adding two durations");
                dynamicError.setErrorCode("FODT0002");
                throw dynamicError;
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot add two durations of different type");
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public DurationValue subtract(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof DayTimeDurationValue) {
            try {
                return DayTimeDurationValue.fromMicroseconds(this.getLengthInMicroseconds() - ((DayTimeDurationValue)durationValue).getLengthInMicroseconds());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DynamicError dynamicError = new DynamicError("Overflow when subtracting two durations");
                dynamicError.setErrorCode("FODT0002");
                throw dynamicError;
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot subtract two durations of different type");
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public DurationValue negate() throws IllegalArgumentException {
        return DayTimeDurationValue.fromMicroseconds(-this.getLengthInMicroseconds());
    }

    public int compareTo(Object object) {
        if (object instanceof DayTimeDurationValue) {
            long l = this.getLengthInMicroseconds() - ((DayTimeDurationValue)object).getLengthInMicroseconds();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
        if (object instanceof DurationValue.DurationValueOrderingKey) {
            return DurationValue.getSchemaComparable(this).compareTo(object);
        }
        throw new ClassCastException("Cannot compare a dayTimeDuration to an object of class " + object.getClass());
    }

    public Comparable getSchemaComparable() {
        return this;
    }

    public Comparable getXPathComparable() {
        return this;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(DurationValue.class)) {
            return this;
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Object.class) {
            return this.getStringValue();
        }
        DynamicError dynamicError = new DynamicError("Conversion of dayTimeDuration to " + clazz.getName() + " is not supported");
        dynamicError.setErrorCode("SXJE0007");
        throw dynamicError;
    }
}

