/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.AlienFile;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.LinuxUtils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.authentication.DuccWebAdministrators;
import org.apache.uima.ducc.ws.registry.IServicesRegistry;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMapPayload;
import org.apache.uima.ducc.ws.server.DuccCookies;
import org.apache.uima.ducc.ws.server.DuccWebSessionManager;
import org.eclipse.jetty.server.Request;

public class HandlersHelper {
    private static DuccLogger duccLogger = DuccLogger.getLogger(HandlersHelper.class);
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    public static DuccWebAdministrators duccWebAdministrators = DuccWebAdministrators.getInstance();
    public static DuccWebSessionManager duccWebSessionManager = DuccWebSessionManager.getInstance();
    private static File devNull = new File("/dev/null");

    private static boolean match(String s1, String s2) {
        String methodName = "match";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        boolean retVal = false;
        if (s1 != null && s2 != null && s1.trim().equals(s2.trim())) {
            retVal = true;
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    public static boolean isServiceController(String user, String serviceId) {
        String methodName = "isServiceController";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        boolean retVal = false;
        duccLogger.debug(methodName, null, new Object[]{user, serviceId});
        try {
            ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
            ServicesRegistryMapPayload payload = servicesRegistry.findServiceById(serviceId);
            Properties meta = payload.meta;
            Properties svc = payload.svc;
            if (HandlersHelper.isServiceOwner(user, meta)) {
                retVal = true;
                duccLogger.debug(methodName, null, new Object[]{"owner"});
            } else if (HandlersHelper.isServiceAdministrator(user, svc)) {
                retVal = true;
                duccLogger.debug(methodName, null, new Object[]{"admin"});
            } else if (HandlersHelper.isDuccAdministrator(user, meta)) {
                retVal = true;
                duccLogger.debug(methodName, null, new Object[]{"ducc admin"});
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    public static boolean isLoggedIn(HttpServletRequest request) {
        boolean retVal = duccWebSessionManager.isAuthentic(request);
        return retVal;
    }

    public static AuthorizationStatus getAuthorizationStatus(HttpServletRequest request, String resourceOwnerUserid) {
        String methodName = "getAuthorizationStatus";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        AuthorizationStatus retVal = AuthorizationStatus.NotLoggedIn;
        try {
            String text = "";
            boolean authenticated = duccWebSessionManager.isAuthentic(request);
            String userId = duccWebSessionManager.getUserId(request);
            if (authenticated) {
                if (HandlersHelper.match(resourceOwnerUserid, userId)) {
                    text = "user " + userId + " is resource owner";
                    retVal = AuthorizationStatus.LoggedInOwner;
                } else {
                    DuccCookies.RequestRole requestRole = DuccCookies.getRole(request);
                    switch (requestRole) {
                        case User: {
                            text = "user " + userId + " is not resource owner " + resourceOwnerUserid;
                            retVal = AuthorizationStatus.LoggedInNotOwner;
                            break;
                        }
                        case Administrator: {
                            if (duccWebAdministrators.isAdministrator(userId)) {
                                text = "user " + userId + " is administrator";
                                retVal = AuthorizationStatus.LoggedInAdministrator;
                                break;
                            }
                            text = "user " + userId + " is not administrator ";
                            retVal = AuthorizationStatus.LoggedInNotAdministrator;
                        }
                    }
                }
            } else {
                text = "user " + userId + " is not authenticated";
                retVal = AuthorizationStatus.NotLoggedIn;
            }
            duccLogger.debug(methodName, null, new Object[]{messages.fetch(text)});
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    public static boolean isUserAuthorized(HttpServletRequest request, String resourceOwnerUserid) {
        String methodName = "isUserAuthorized";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        boolean retVal = false;
        try {
            AuthorizationStatus authorizationStatus = HandlersHelper.getAuthorizationStatus(request, resourceOwnerUserid);
            switch (authorizationStatus) {
                case LoggedInOwner: 
                case LoggedInAdministrator: {
                    retVal = true;
                    break;
                }
                case LoggedInNotOwner: 
                case LoggedInNotAdministrator: 
                case NotLoggedIn: {
                    break;
                }
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    private static DuccId getDuccId(Properties meta) {
        String location = "getDuccId";
        DuccId retVal = null;
        String numeric_id = null;
        try {
            numeric_id = meta.getProperty(IServicesRegistry.numeric_id);
            Long svcNo = new Long(numeric_id);
            retVal = new DuccId(svcNo.longValue());
        }
        catch (Exception e) {
            duccLogger.error(location, retVal, new Object[]{numeric_id});
        }
        return retVal;
    }

    private static boolean isServiceOwner(String reqUser, Properties meta) {
        String location = "isServiceOwner";
        boolean retVal = false;
        if (reqUser != null) {
            if (meta != null) {
                String svcOwner = meta.getProperty(IServicesRegistry.user);
                if (svcOwner != null) {
                    if (reqUser.trim().equals(svcOwner.trim())) {
                        retVal = true;
                        duccLogger.debug(location, HandlersHelper.getDuccId(meta), new Object[]{"user=" + reqUser + " " + retVal});
                    }
                } else {
                    duccLogger.debug(location, HandlersHelper.getDuccId(meta), new Object[]{"svcOwner=" + svcOwner + " " + retVal});
                }
            } else {
                duccLogger.debug(location, HandlersHelper.getDuccId(meta), new Object[]{"meta=" + meta + " " + retVal});
            }
        } else {
            duccLogger.debug(location, HandlersHelper.getDuccId(meta), new Object[]{"user=" + reqUser + " " + retVal});
        }
        return retVal;
    }

    private static boolean isServiceAdministrator(String reqUser, Properties svc) {
        String svcAdministrators;
        String location = "isServiceAdministrator";
        boolean retVal = false;
        if (reqUser != null && svc != null && (svcAdministrators = svc.getProperty(IServicesRegistry.administrators)) != null) {
            String[] tokens;
            for (String token : tokens = svcAdministrators.split("\\s+")) {
                if (!reqUser.trim().equals(token.trim())) continue;
                retVal = true;
                duccLogger.debug(location, HandlersHelper.getDuccId(svc), new Object[]{"user=" + reqUser + " " + retVal});
                break;
            }
        }
        return retVal;
    }

    protected static boolean isDuccAdministrator(String reqUser, Properties meta) {
        String location = "isDuccAdministrator";
        boolean retVal = false;
        if (reqUser != null && (retVal = DuccWebAdministrators.getInstance().isAdministrator(reqUser))) {
            duccLogger.debug(location, HandlersHelper.getDuccId(meta), new Object[]{"user=" + reqUser + " " + retVal + " (forced)"});
        }
        return retVal;
    }

    public static boolean isFileReadable(String user, String path) {
        String location = "isFileReadable";
        boolean retVal = false;
        try {
            AlienFile alienFile = new AlienFile(user, path);
            String contents = alienFile.getString();
            if (contents != null) {
                retVal = true;
            }
        }
        catch (Exception e) {
            duccLogger.debug(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private static boolean isServiceFileAccessForRead(String reqUser, Properties meta) {
        String location = "isServiceFileAccessForRead";
        boolean retVal = false;
        String DUCC_HOME = System.getProperty("DUCC_HOME");
        String duccmon_pwgen = DUCC_HOME + "/admin/db_access_check.py";
        String owner = meta.getProperty(IServicesRegistry.user);
        String looker = reqUser;
        if (looker == null) {
            duccLogger.debug(location, null, new Object[]{"looker not specified"});
        } else {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(duccmon_pwgen);
            cmd.add("--owner");
            cmd.add(owner);
            cmd.add("--looker");
            cmd.add(looker);
            String cmdline = String.join((CharSequence)" ", cmd);
            duccLogger.debug(location, null, new Object[]{"cmdline: " + cmdline});
            ProcessBuilder pb = new ProcessBuilder(cmd);
            String authorizedCode = "1";
            try {
                String line;
                pb = pb.redirectError(devNull);
                Process process = pb.start();
                BufferedReader bri = new BufferedReader(new InputStreamReader(process.getInputStream()));
                duccLogger.trace(location, null, new Object[]{"read stdout: start"});
                while ((line = bri.readLine()) != null) {
                    duccLogger.debug(location, null, new Object[]{"stdout: " + line});
                    if (!line.startsWith(authorizedCode)) continue;
                    duccLogger.trace(location, null, new Object[]{"authorized!"});
                    retVal = true;
                }
                bri.close();
                duccLogger.trace(location, null, new Object[]{"read stdout: end"});
                duccLogger.trace(location, null, new Object[]{"process waitfor: start"});
                process.waitFor();
                duccLogger.trace(location, null, new Object[]{"process waitfor: end"});
            }
            catch (Exception e) {
                duccLogger.error(location, null, (Throwable)e, new Object[0]);
            }
        }
        return retVal;
    }

    public static String getSecurityHome(String user) {
        String runmode = DuccPropertiesResolver.get((String)"ducc.runmode");
        boolean testMode = runmode != null && runmode.equals("Test");
        String dirHome = null;
        String ducc_security_home = DuccPropertiesResolver.get((String)"ducc.security.home");
        if (ducc_security_home != null && !ducc_security_home.isEmpty()) {
            String realUser = testMode ? System.getProperty("user.name") : user;
            dirHome = ducc_security_home + File.separator + realUser;
        }
        if (dirHome == null) {
            dirHome = testMode ? System.getProperty("user.home") : LinuxUtils.getUserHome((String)user);
        }
        return dirHome;
    }

    public static DataAccessPermission getServiceAuthorization(Request request) {
        String methodName = "getServiceAuthorization";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        DataAccessPermission retVal = DataAccessPermission.None;
        try {
            if (request != null) {
                String reqUser = duccWebSessionManager.getUserId((HttpServletRequest)request);
                String name = request.getParameter("name");
                ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
                ServicesRegistryMapPayload payload = servicesRegistry.findService(name);
                if (payload != null) {
                    Properties svc = payload.svc;
                    Properties meta = payload.meta;
                    if (HandlersHelper.isServiceOwner(reqUser, meta)) {
                        retVal = DataAccessPermission.Write;
                    } else if (HandlersHelper.isServiceAdministrator(reqUser, svc)) {
                        retVal = DataAccessPermission.Write;
                    } else if (HandlersHelper.isServiceFileAccessForRead(reqUser, meta)) {
                        retVal = DataAccessPermission.Read;
                    }
                }
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    public static DataAccessPermission getResourceAuthorization(String resOwner, String reqUser) {
        String methodName = "getServiceAuthorization";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        DataAccessPermission retVal = DataAccessPermission.None;
        try {
            if (resOwner == reqUser) {
                retVal = DataAccessPermission.Read;
            } else {
                String home = HandlersHelper.getSecurityHome(resOwner.trim());
                if (home != null) {
                    String path;
                    boolean readable;
                    if (!home.endsWith(File.separator)) {
                        home = home + File.separator;
                    }
                    if (readable = HandlersHelper.isFileReadable(reqUser, path = home + ".ducc" + File.separator + "db.access")) {
                        retVal = DataAccessPermission.Read;
                        duccLogger.debug(methodName, jobid, new Object[]{"owner=" + resOwner + " user=" + reqUser + " " + (Object)((Object)retVal)});
                    }
                }
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    public static boolean isResourceAuthorized(String resOwner, String reqUser) {
        boolean retVal = false;
        DataAccessPermission dap = HandlersHelper.getResourceAuthorization(resOwner, reqUser);
        switch (dap) {
            case Read: 
            case Write: {
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public static enum DataAccessPermission {
        None,
        Read,
        Write;

    }

    public static enum AuthorizationStatus {
        LoggedInOwner,
        LoggedInAdministrator,
        LoggedInNotOwner,
        LoggedInNotAdministrator,
        NotLoggedIn;

    }
}

