/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.helper;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class DiagnosticsHelper
extends Thread {
    private static DuccLogger duccLogger = DuccLogger.getLogger((String)DiagnosticsHelper.class.getName(), null);
    private static DuccId jobid = null;
    private static File devNull = new File("/dev/null");
    private static AtomicReference<DiagnosticsHelper> instance = new AtomicReference();
    private static AtomicReference<String> disk_info = new AtomicReference();
    private static long interval = 3600000L;

    private static void refresh_ducc_disk_info() {
        String location = "refresh_ducc_disk_info";
        StringBuffer sb = new StringBuffer();
        duccLogger.debug(location, jobid, new Object[]{"time start"});
        try {
            String line;
            String path = System.getProperty("DUCC_HOME") + File.separator + "admin" + File.separator + "ducc_disk_info";
            String[] command = new String[]{path};
            ProcessBuilder pb = new ProcessBuilder(command);
            pb = pb.redirectError(devNull);
            Process process = pb.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            disk_info.set(sb.toString());
            duccLogger.info(location, jobid, new Object[]{disk_info});
            int exitValue = process.waitFor();
            duccLogger.debug(location, jobid, new Object[]{"rc=" + exitValue});
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        duccLogger.debug(location, jobid, new Object[]{"time end"});
    }

    public static String get_ducc_disk_info() {
        return disk_info.get();
    }

    public static boolean isNotKilled() {
        return true;
    }

    @Override
    public void run() {
        String location = "run";
        while (DiagnosticsHelper.isNotKilled()) {
            try {
                DiagnosticsHelper.refresh_ducc_disk_info();
                duccLogger.debug(location, jobid, new Object[]{"sleep " + interval + " begin"});
                Thread.sleep(interval);
                duccLogger.debug(location, jobid, new Object[]{"sleep " + interval + " end"});
            }
            catch (Exception e) {
                duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
    }

    static {
        String location = "initializer";
        Object expect = null;
        DiagnosticsHelper update = new DiagnosticsHelper();
        boolean result = instance.compareAndSet((DiagnosticsHelper)expect, update);
        if (result) {
            instance.get().start();
            duccLogger.info(location, jobid, new Object[]{"thread started"});
        } else {
            duccLogger.info(location, jobid, new Object[]{"thread running"});
        }
    }
}

