/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.jms;

import java.io.FileNotFoundException;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.uima.ducc.common.authentication.BrokerCredentials;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonConfiguration.class})
public class JmsTransport {
    @Autowired
    CommonConfiguration common;
    @Value(value="#{ systemProperties['ducc.broker.url'] }")
    String brokerUrl;
    @Value(value="#{ systemProperties['ducc.broker.credentials.file'] }")
    String brokerCredentialsFile;

    private ConnectionFactory getConnectionFactory() {
        ActiveMQConnectionFactory connectionFactory;
        BrokerCredentials.Credentials credentials = null;
        try {
            credentials = BrokerCredentials.get((String)this.brokerCredentialsFile);
            connectionFactory = credentials.getUsername() != null && credentials.getPassword() != null ? new ActiveMQConnectionFactory(credentials.getUsername(), credentials.getPassword(), this.brokerUrl) : new ActiveMQConnectionFactory(this.brokerUrl);
        }
        catch (FileNotFoundException fne) {
            connectionFactory = new ActiveMQConnectionFactory(this.brokerUrl);
        }
        return connectionFactory;
    }

    @Bean
    public CamelContext jmsContext() {
        CamelContext ctx = this.common.camelContext();
        if (ctx.getComponent("activemq") == null) {
            ConnectionFactory connectionFactory = this.getConnectionFactory();
            JmsComponent jmsComponent = JmsComponent.jmsComponentAutoAcknowledge((ConnectionFactory)connectionFactory);
            ctx.addComponent("activemq", (Component)jmsComponent);
        }
        return ctx;
    }

    @Bean
    public CamelContext jmsContextWithClientACK() {
        CamelContext ctx = this.common.camelContext();
        if (ctx.getComponent("activemq") == null) {
            ConnectionFactory connectionFactory = this.getConnectionFactory();
            JmsComponent jmsComponent = JmsComponent.jmsComponentClientAcknowledge((ConnectionFactory)connectionFactory);
            ctx.addComponent("activemq", (Component)jmsComponent);
        }
        return ctx;
    }

    @Bean
    public DuccEventDispatcher duccEventDispatcher() {
        return new DuccEventDispatcher(this.common.camelContext());
    }
}

