/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jp;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class UimaServiceThreadFactory
implements ThreadFactory {
    private static final String THREAD_POOL = "[UimaServiceThreadPool ";
    private ThreadGroup theThreadGroup;
    private String threadNamePrefix = null;
    private boolean isDaemon = false;
    public static AtomicInteger poolIdGenerator = new AtomicInteger();
    private final int poolId = poolIdGenerator.incrementAndGet();

    public UimaServiceThreadFactory(ThreadGroup tGroup) {
        this.theThreadGroup = tGroup;
    }

    public void setThreadNamePrefix(String prefix) {
        this.threadNamePrefix = prefix;
    }

    public void setThreadGroup(ThreadGroup tGroup) {
        this.theThreadGroup = tGroup;
    }

    public void setDaemon(boolean daemon) {
    }

    public void stop() {
    }

    @Override
    public Thread newThread(final Runnable r) {
        Thread newThread = null;
        try {
            newThread = new Thread(this.theThreadGroup, new Runnable(){

                @Override
                public void run() {
                    if (UimaServiceThreadFactory.this.threadNamePrefix == null) {
                        UimaServiceThreadFactory.this.threadNamePrefix = UimaServiceThreadFactory.THREAD_POOL + UimaServiceThreadFactory.this.poolId + "]  Process Thread";
                    }
                    Thread.currentThread().setName(UimaServiceThreadFactory.this.threadNamePrefix + " - " + Thread.currentThread().getId());
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newThread != null) {
            newThread.setDaemon(this.isDaemon);
        }
        return newThread;
    }
}

