/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.common.fsm;

import org.apache.uima.ducc.container.common.fsm.FsmException;
import org.apache.uima.ducc.container.common.fsm.iface.IEvent;
import org.apache.uima.ducc.container.common.fsm.iface.IState;
import org.apache.uima.ducc.container.common.fsm.iface.IStateEventKey;

public class StateEventKey
implements IStateEventKey {
    private IState state = null;
    private IEvent event = null;

    public StateEventKey(IState state, IEvent event) throws FsmException {
        if (state == null) {
            throw new FsmException("state object is null");
        }
        if (event == null) {
            throw new FsmException("event object is null");
        }
        this.setState(state);
        this.setEvent(event);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        boolean retVal = false;
        if (o != null && o instanceof IStateEventKey) {
            IStateEventKey that = (IStateEventKey)o;
            IState thatState = that.getState();
            IEvent thatEvent = that.getEvent();
            if (thatState != null && thatEvent != null && thatState.equals(this.state) && thatEvent.equals(this.event)) {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public int compareTo(Object o) {
        int retVal = 0;
        if (this.state != null && this.event != null && o != null) {
            StateEventKey that = (StateEventKey)o;
            retVal = this.state.compareTo(that.state);
            if (retVal == 0) {
                retVal = this.event.compareTo(that.event);
            }
        }
        return retVal;
    }

    private void setState(IState value) {
        this.state = value;
    }

    @Override
    public IState getState() {
        return this.state;
    }

    private void setEvent(IEvent value) {
        this.event = value;
    }

    @Override
    public IEvent getEvent() {
        return this.event;
    }
}

