/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.AsynchAECasManager;
import org.apache.uima.aae.EECasManager_impl;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.CasDefinition;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLInputSource;

public class AsynchAECasManager_impl
implements AsynchAECasManager {
    private static final Class CLASS_NAME = AsynchAECasManager_impl.class;
    private String contextName;
    private CasManager casManager;
    private int casPoolSize = 1;
    private volatile boolean initialized;
    private Map descriptorMap;
    private Map processingResourceMap = new HashMap();
    private ResourceManager resourceManager;
    private long initialHeapSize = 0L;
    boolean disableJCasCache = false;

    public AsynchAECasManager_impl(ResourceManager aResourceManager, Map aDescriptorMap) {
        this(aResourceManager);
        this.descriptorMap = aDescriptorMap;
    }

    public AsynchAECasManager_impl(ResourceManager aResourceManager) {
        this.casManager = new EECasManager_impl(aResourceManager);
        aResourceManager.setCasManager(this.casManager);
        this.resourceManager = aResourceManager;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public void initialize(String aContextName) throws Exception {
        this.initialize(this.getCasPoolSize(), aContextName);
    }

    @Override
    public void initialize(int aCasPoolSize, String aContextName) throws Exception {
        this.initialize(aCasPoolSize, aContextName, new Properties());
    }

    @Override
    public synchronized void initialize(int aCasPoolSize, String aContextName, Properties aPerformanceTuningSettings) throws Exception {
        if (this.initialHeapSize > 0L && !aPerformanceTuningSettings.containsKey("cas_initial_heap_size")) {
            aPerformanceTuningSettings.setProperty("cas_initial_heap_size", Integer.valueOf((int)this.initialHeapSize).toString());
        }
        if (this.disableJCasCache) {
            aPerformanceTuningSettings.setProperty("jcas_cache_enabled", String.valueOf(Boolean.FALSE));
        }
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "uimaee_messages", "UIMAEE_primary_cas_pool_init__CONFIG", new Object[]{aCasPoolSize, aContextName, aPerformanceTuningSettings.get("cas_initial_heap_size")});
        }
        this.casManager.defineCasPool(aContextName, aCasPoolSize, aPerformanceTuningSettings);
        this.contextName = aContextName;
        this.setInitialized(true);
    }

    public int getCasPoolSize() {
        return this.casPoolSize;
    }

    public void setCasPoolSize(int casPoolSize) {
        this.casPoolSize = casPoolSize;
        this.setInitialized(true);
    }

    @Override
    public String getCasManagerContext() {
        return this.contextName;
    }

    @Override
    public CasManager getInternalCasManager() {
        return this.casManager;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public void addMetadata(ProcessingResourceMetaData meta) {
        this.casManager.addMetaData(meta);
    }

    @Override
    public void setMetadata(ProcessingResourceMetaData meta) {
        this.addMetadata(meta);
    }

    @Override
    public ProcessingResourceMetaData getMetadata() throws ResourceInitializationException {
        CasDefinition casDefinition = this.casManager.getCasDefinition();
        ProcessingResourceMetaData md = UIMAFramework.getResourceSpecifierFactory().createProcessingResourceMetaData();
        md.setTypeSystem(casDefinition.getTypeSystemDescription());
        md.setTypePriorities(casDefinition.getTypePriorities());
        FsIndexCollection indColl = UIMAFramework.getResourceSpecifierFactory().createFsIndexCollection();
        indColl.setFsIndexes(casDefinition.getFsIndexDescriptions());
        md.setFsIndexCollection(indColl);
        return md;
    }

    @Override
    public Map getMetadataAsMap() throws ResourceInitializationException {
        return this.processingResourceMap;
    }

    public void setMetadata(String aDescriptorName) throws Exception {
        AnalysisEngineDescription specifier = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(new File(aDescriptorName)));
        AnalysisEngineMetaData meta = specifier.getAnalysisEngineMetaData();
        this.addMetadata((ProcessingResourceMetaData)meta);
    }

    private void addProcessingResourceMetadata(String mapkey, String aDescriptorName) throws Exception {
        AnalysisEngineDescription specifier = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(new File(aDescriptorName)));
        AnalysisEngineMetaData meta = specifier.getAnalysisEngineMetaData();
        this.addMetadata((ProcessingResourceMetaData)meta);
        this.processingResourceMap.put(mapkey, meta);
    }

    @Override
    public CAS getNewCas() {
        return this.casManager.getCas(this.contextName);
    }

    @Override
    public CAS getNewCas(String aContext) {
        return this.casManager.getCas(aContext);
    }

    @Override
    public void setInitialFsHeapSize(long aSizeInBytes) {
        this.initialHeapSize = aSizeInBytes / 4L;
    }

    @Override
    public long getInitialFsHeapSize() {
        return this.initialHeapSize;
    }

    public void setDisableJCasCache(boolean disableJCasCache) {
        this.disableJCasCache = disableJCasCache;
    }

    public boolean getDisableJCasCache() {
        return this.disableJCasCache;
    }

    public void destroy() {
        try {
            ((EECasManager_impl)this.casManager).destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

