/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.message;

import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.spi.transport.UimaMessage;
import org.apache.uima.util.Level;

public class UimaMessageValidator {
    private static final Class CLASS_NAME = UimaMessageValidator.class;

    private static String getEndpointName(UimaMessage aMessage) throws IllegalArgumentException {
        String endpointName = aMessage.getStringProperty("MessageFrom");
        if (endpointName == null) {
            throw new IllegalArgumentException("Invalid Message. Missing 'MessageFrom' Property.");
        }
        return endpointName;
    }

    public static boolean validMessageType(UimaMessage aMessage, String endpointName) throws Exception {
        if (aMessage.containsProperty("MessageType")) {
            int msgType = aMessage.getIntProperty("MessageType");
            if (msgType != 3001 && msgType != 3000) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validMessageType", "uimaee_messages", "UIMAJMS_invalid_msgtype_in_message__INFO", new Object[]{msgType, endpointName});
                }
                return false;
            }
        } else {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validMessageType", "uimaee_messages", "UIMAJMS_msgtype_notin_message__INFO", new Object[]{endpointName});
            }
            return false;
        }
        return true;
    }

    public static boolean isRequest(UimaMessage aMessage) throws Exception {
        if (aMessage.containsProperty("MessageType")) {
            int msgType = aMessage.getIntProperty("MessageType");
            return msgType == 3000;
        }
        return false;
    }

    public static boolean isProcessRequest(UimaMessage aMessage) throws Exception {
        if (!UimaMessageValidator.isRequest(aMessage)) {
            return false;
        }
        if (aMessage.containsProperty("Command")) {
            int command = aMessage.getIntProperty("Command");
            return command == 2000;
        }
        return false;
    }

    public static boolean validCommand(UimaMessage aMessage, String endpointName) throws Exception {
        if (aMessage.containsProperty("Command")) {
            int command = aMessage.getIntProperty("Command");
            if (command != 2000 && command != 2001 && command != 2005 && command != 2006 && command != 2007 && command != 2002) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validCommand", "uimaee_messages", "UIMAJMS_invalid_command_in_message__INFO", new Object[]{command, endpointName});
                }
                return false;
            }
        } else {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validCommand", "uimaee_messages", "UIMAJMS_command_notin_message__INFO", new Object[]{endpointName});
            }
            return false;
        }
        return true;
    }

    public static boolean validPayload(UimaMessage aMessage, String endpointName) throws Exception {
        int command;
        if (aMessage.containsProperty("Command") && ((command = aMessage.getIntProperty("Command")) == 2001 || command == 2002 || command == 2007 || command == 2006 || command == 2005)) {
            return true;
        }
        if (aMessage.containsProperty("Payload")) {
            int payload = aMessage.getIntProperty("Payload");
            if (payload != 1000 && payload != 1001 && payload != 1006 && payload != 1003 && payload != 1002) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validPayload", "uimaee_messages", "UIMAJMS_invalid_payload_in_message__INFO", new Object[]{payload, endpointName});
                }
                return false;
            }
        } else {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "validPayload", "uimaee_messages", "UIMAJMS_payload_notin_message__INFO", new Object[]{endpointName});
            }
            return false;
        }
        return true;
    }

    public static boolean isStaleMessage(UimaMessage aMessage, boolean isStopped, String endpointName, boolean entryExists) {
        if (isStopped) {
            return true;
        }
        int command = aMessage.getIntProperty("Command");
        int msgType = aMessage.getIntProperty("MessageType");
        if (command == 2000 && msgType == 3001) {
            String casReferenceId = aMessage.getStringProperty("CasReference");
            if (!entryExists) {
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "isStaleMessage", "uimaee_messages", "UIMAJMS_stale_message__FINE", new Object[]{endpointName, casReferenceId, aMessage.getStringProperty("MessageFrom")});
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isValidMessage(UimaMessage aMessage, AnalysisEngineController controller) throws Exception {
        String endpointName = UimaMessageValidator.getEndpointName(aMessage);
        if (!UimaMessageValidator.validMessageType(aMessage, endpointName)) {
            return false;
        }
        if (!UimaMessageValidator.validCommand(aMessage, endpointName)) {
            return false;
        }
        if (!UimaMessageValidator.validPayload(aMessage, endpointName)) {
            return false;
        }
        String casReferenceId = aMessage.getStringProperty("CasReference");
        return !UimaMessageValidator.isStaleMessage(aMessage, controller.isStopped(), endpointName, controller.getInProcessCache().entryExists(casReferenceId));
    }

    public static String decodeIntToString(String aTypeToDecode, int aValueToDecode) {
        if ("MessageType".equals(aTypeToDecode)) {
            switch (aValueToDecode) {
                case 3000: {
                    return "Request";
                }
                case 3001: {
                    return "Response";
                }
            }
        } else if ("Command".equals(aTypeToDecode)) {
            switch (aValueToDecode) {
                case 2000: {
                    return "Process";
                }
                case 2001: {
                    return "GetMetadata";
                }
                case 2002: {
                    return "CollectionProcessComplete";
                }
                case 2005: {
                    return "ReleaseCAS";
                }
                case 2006: {
                    return "Stop";
                }
                case 2007: {
                    return "Ping";
                }
            }
        } else if ("Payload".equals(aTypeToDecode)) {
            switch (aValueToDecode) {
                case 1000: {
                    return "XMIPayload";
                }
                case 1006: {
                    return "BinaryPayload";
                }
                case 1001: {
                    return "CASRefID";
                }
                case 1002: {
                    return "Metadata";
                }
                case 1003: {
                    return "Exception";
                }
                case 1005: {
                    return "None";
                }
            }
        }
        return "UNKNOWN";
    }
}

