/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.monitor.statistics.AEMetrics;
import org.apache.uima.aae.monitor.statistics.AnalysisEnginePerformanceMetrics;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.util.Level;

public class LocalCache
extends ConcurrentHashMap<String, CasStateEntry> {
    private static final long serialVersionUID = 1L;
    private static final Class CLASS_NAME = LocalCache.class;
    private AnalysisEngineController controller;

    public LocalCache(AnalysisEngineController aController) {
        this.controller = aController;
    }

    public CasStateEntry createCasStateEntry(String aCasReferenceId) {
        CasStateEntry entry = new CasStateEntry(aCasReferenceId);
        super.put(aCasReferenceId, entry);
        Collections.synchronizedCollection(entry.getAEPerformanceList());
        return entry;
    }

    public CasStateEntry lookupEntry(String aCasReferenceId) {
        if (super.containsKey(aCasReferenceId)) {
            return (CasStateEntry)super.get(aCasReferenceId);
        }
        return null;
    }

    public String lookupInputCasReferenceId(String aCasReferenceId) {
        String parentCasReferenceId = null;
        if (this.containsKey(aCasReferenceId)) {
            CasStateEntry entry = (CasStateEntry)this.get(aCasReferenceId);
            if (entry != null && entry.isSubordinate()) {
                parentCasReferenceId = this.lookupInputCasReferenceId(entry.getInputCasReferenceId());
            } else {
                return aCasReferenceId;
            }
        }
        return parentCasReferenceId;
    }

    public String lookupInputCasReferenceId(CasStateEntry entry) {
        String parentCasReferenceId = null;
        if (!entry.isSubordinate()) {
            return entry.getCasReferenceId();
        }
        parentCasReferenceId = this.lookupInputCasReferenceId((CasStateEntry)this.get(entry.getInputCasReferenceId()));
        return parentCasReferenceId;
    }

    public void dumpContents() {
        this.dumpContents(false);
    }

    public synchronized void dumpContents(boolean dump2Stdout) {
        int count = 0;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            StringBuffer sb = new StringBuffer("\n");
            for (Map.Entry entry : this.entrySet()) {
                CasStateEntry casStateEntry = (CasStateEntry)entry.getValue();
                if (casStateEntry == null) continue;
                ++count;
                if (casStateEntry.isSubordinate()) {
                    sb.append(entry.getKey() + " Number Of Child CASes In Play:" + casStateEntry.getSubordinateCasInPlayCount() + " Parent CAS id:" + casStateEntry.getInputCasReferenceId());
                } else {
                    sb.append(entry.getKey() + " *** Input CAS. Number Of Child CASes In Play:" + casStateEntry.getSubordinateCasInPlayCount());
                }
                if (casStateEntry.isWaitingForRelease()) {
                    sb.append(" <<< Reached Final State in Controller:" + this.controller.getComponentName());
                }
                sb.append("\n");
            }
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "dumpContents", "uimaee_messages", "UIMAEE_show_cache_entry_key__FINEST", new Object[]{this.controller.getComponentName(), count, sb.toString()});
            if (dump2Stdout) {
                System.out.println(sb.toString());
            }
            sb.setLength(0);
        } else if (UIMAFramework.getLogger().isLoggable(Level.FINE)) {
            int inFinalState = 0;
            for (Map.Entry entry : this.entrySet()) {
                CasStateEntry casStateEntry = (CasStateEntry)entry.getValue();
                ++count;
                if (casStateEntry == null || !casStateEntry.isWaitingForRelease()) continue;
                ++inFinalState;
            }
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "dumpContents", "uimaee_messages", "UIMAEE_show_abbrev_cache_stats___FINE", new Object[]{this.controller.getComponentName(), count, inFinalState});
        }
    }

    public synchronized void remove(String aCasReferenceId) {
        if (aCasReferenceId != null && this.containsKey(aCasReferenceId)) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "remove", "uimaee_messages", "UIMAEE_remove_cache_entry_for_cas__FINE", new Object[]{aCasReferenceId});
            }
            super.remove(aCasReferenceId);
            this.notifyAll();
        } else if (aCasReferenceId == null) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "remove", "uimaee_messages", "UIMAEE_cas_is_null_remove_from_cache_failed__FINE");
            }
        } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, this.getClass().getName(), "remove", "uimaee_messages", "UIMAEE_cas_is_invalid_remove_from_cache_failed__FINE", new Object[]{aCasReferenceId});
        }
    }

    public CasStateEntry getTopCasAncestor(String casReferenceId) throws Exception {
        if (!this.containsKey(casReferenceId)) {
            return null;
        }
        CasStateEntry casStateEntry = this.lookupEntry(casReferenceId);
        if (casStateEntry.isSubordinate()) {
            return this.getTopCasAncestor(casStateEntry.getInputCasReferenceId());
        }
        return casStateEntry;
    }

    public static class CasStateEntry {
        private String casReferenceId;
        private volatile boolean waitingForChildren;
        private volatile boolean waitingForRealease;
        private volatile boolean pendingReply;
        private volatile boolean subordinateCAS;
        private volatile boolean replyReceived;
        private volatile boolean failed;
        private volatile boolean dropped;
        private List<Throwable> exceptionList = new ArrayList<Throwable>();
        private FinalStep step;
        private int state;
        private int subordinateCasInPlayCount;
        private Object childCountMux = new Object();
        private String inputCasReferenceId;
        private int numberOfParallelDelegates = 1;
        private Delegate lastDelegate = null;
        private int howManyDelegatesResponded = 0;
        private Endpoint freeCasNotificationEndpoint;
        private volatile boolean deliveryToClientFailed;
        private String hostIpProcessingCAS;
        private Semaphore flowSemaphore = new Semaphore(1);
        private AtomicInteger childCasOutstandingFlowCounter = new AtomicInteger();
        private List<AnalysisEnginePerformanceMetrics> performanceList = new ArrayList<AnalysisEnginePerformanceMetrics>();
        private Object monitor = new Object();
        private CountDownLatch latch = null;
        protected Map<String, AEMetrics> casMetrics = new TreeMap<String, AEMetrics>();

        public boolean waitingForChildrenToFinish() {
            return this.waitingForChildren;
        }

        public void waitingForChildrenToFinish(boolean waiting) {
            this.waitingForChildren = waiting;
        }

        public String getHostIpProcessingCAS() {
            return this.hostIpProcessingCAS;
        }

        public void addMetrics(List<AnalysisEnginePerformanceMetrics> metrics) {
            for (AnalysisEnginePerformanceMetrics m : metrics) {
                AEMetrics aeMetrics;
                if (this.casMetrics.containsKey(m.getUniqueName())) {
                    aeMetrics = this.casMetrics.get(m.getUniqueName());
                } else {
                    aeMetrics = new AEMetrics();
                    aeMetrics.setName(m.getName());
                    this.casMetrics.put(m.getUniqueName(), aeMetrics);
                }
                aeMetrics.incrementAnalysisTime(m.getAnalysisTime());
                aeMetrics.incrementNumProcessed(m.getNumProcessed());
            }
        }

        public List<AnalysisEnginePerformanceMetrics> getCASMetrics() {
            ArrayList<AnalysisEnginePerformanceMetrics> list = new ArrayList<AnalysisEnginePerformanceMetrics>();
            for (Map.Entry<String, AEMetrics> m : this.casMetrics.entrySet()) {
                AnalysisEnginePerformanceMetrics metrics = new AnalysisEnginePerformanceMetrics(m.getValue().getName(), m.getKey(), m.getValue().getAnalysisTime().get(), m.getValue().getNumProcessed().get());
                list.add(metrics);
            }
            return list;
        }

        public void setHostIpProcessingCAS(String hostIpProcessingCAS) {
            this.hostIpProcessingCAS = hostIpProcessingCAS;
        }

        public boolean deliveryToClientFailed() {
            return this.deliveryToClientFailed;
        }

        public void setDeliveryToClientFailed() {
            this.deliveryToClientFailed = true;
        }

        public boolean isDropped() {
            return this.dropped;
        }

        public void setDropped(boolean dropped) {
            this.dropped = dropped;
        }

        public Endpoint getFreeCasNotificationEndpoint() {
            return this.freeCasNotificationEndpoint;
        }

        public void setFreeCasNotificationEndpoint(Endpoint freeCasNotificationEndpoint) {
            this.freeCasNotificationEndpoint = freeCasNotificationEndpoint;
        }

        public CasStateEntry(String aCasReferenceId) {
            this.casReferenceId = aCasReferenceId;
        }

        public void setLastDelegate(Delegate aDelegate) {
            this.lastDelegate = aDelegate;
        }

        public Delegate getLastDelegate() {
            return this.lastDelegate;
        }

        public String getCasReferenceId() {
            return this.casReferenceId;
        }

        public String getInputCasReferenceId() {
            return this.inputCasReferenceId;
        }

        public void setInputCasReferenceId(String anInputCasReferenceId) {
            this.inputCasReferenceId = anInputCasReferenceId;
            this.subordinateCAS = true;
        }

        public void setWaitingForRelease(boolean flag) {
            this.waitingForRealease = flag;
        }

        public boolean isWaitingForRelease() {
            return this.waitingForRealease;
        }

        public void setFinalStep(FinalStep step) {
            this.step = step;
        }

        public FinalStep getFinalStep() {
            return this.step;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int aState) {
            this.state = aState;
        }

        public boolean isSubordinate() {
            return this.subordinateCAS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSubordinateCasInPlayCount() {
            Object object = this.childCountMux;
            synchronized (object) {
                return this.subordinateCasInPlayCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementSubordinateCasInPlayCount() {
            Object object = this.childCountMux;
            synchronized (object) {
                ++this.subordinateCasInPlayCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int decrementSubordinateCasInPlayCount() {
            Object object = this.childCountMux;
            synchronized (object) {
                if (this.subordinateCasInPlayCount > 0) {
                    --this.subordinateCasInPlayCount;
                }
                return this.subordinateCasInPlayCount;
            }
        }

        public boolean isPendingReply() {
            return this.pendingReply;
        }

        public void setPendingReply(boolean pendingReply) {
            this.pendingReply = pendingReply;
        }

        public void setReplyReceived() {
            this.replyReceived = true;
        }

        public boolean isReplyReceived() {
            return this.replyReceived;
        }

        public void resetReplyReceived() {
            this.replyReceived = false;
        }

        public synchronized void incrementHowManyDelegatesResponded() {
            if (this.howManyDelegatesResponded < this.numberOfParallelDelegates) {
                ++this.howManyDelegatesResponded;
            }
        }

        public synchronized int howManyDelegatesResponded() {
            return this.howManyDelegatesResponded;
        }

        public synchronized void resetDelegateResponded() {
            this.howManyDelegatesResponded = 0;
        }

        public void setNumberOfParallelDelegates(int aNumberOfParallelDelegates) {
            this.numberOfParallelDelegates = aNumberOfParallelDelegates;
            this.latch = new CountDownLatch(aNumberOfParallelDelegates);
        }

        public int getNumberOfParallelDelegates() {
            return this.numberOfParallelDelegates;
        }

        public void dispatchedCasToParallelDelegate() {
            if (this.latch != null && this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
        }

        public void blockIfParallelDispatchNotComplete() {
            try {
                if (this.latch != null) {
                    this.latch.await();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void resetDispatchLatch() {
            if (this.latch != null) {
                while (this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
            }
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void setFailed() {
            this.failed = true;
        }

        public void addThrowable(Throwable t) {
            this.exceptionList.add(t);
        }

        public List<Throwable> getErrors() {
            return this.exceptionList;
        }

        public void acquireFlowSemaphore() throws InterruptedException {
            this.flowSemaphore.acquire();
        }

        public void releaseFlowSemaphore() {
            this.flowSemaphore.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementOutstandingFlowCounter() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.childCasOutstandingFlowCounter.incrementAndGet() == 1) {
                    try {
                        this.acquireFlowSemaphore();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrementOutstandingFlowCounter() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.flowSemaphore.availablePermits() == 0) {
                    if (this.childCasOutstandingFlowCounter.get() > 0) {
                        this.childCasOutstandingFlowCounter.decrementAndGet();
                    }
                    this.releaseFlowSemaphore();
                }
            }
        }

        public List<AnalysisEnginePerformanceMetrics> getAEPerformanceList() {
            return this.performanceList;
        }
    }
}

