/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

final class TinyCommentImpl
extends TinyNodeImpl {
    public TinyCommentImpl(TinyTree tinyTree, int n) {
        this.tree = tinyTree;
        this.nodeNr = n;
    }

    public final String getStringValue() {
        int n = this.tree.alpha[this.nodeNr];
        int n2 = this.tree.beta[this.nodeNr];
        if (n2 == 0) {
            return "";
        }
        char[] cArray = new char[n2];
        this.tree.commentBuffer.getChars(n, n + n2, cArray, 0);
        return new String(cArray, 0, n2);
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new StringValue(this.getStringValue()));
    }

    public Value atomize() {
        return new StringValue(this.getStringValue());
    }

    public final int getNodeKind() {
        return 8;
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        receiver.comment(this.getStringValue(), 0, 0);
    }
}

