/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.feature;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.MatchReference;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.feature.CoveredTextFeature;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.LazyFeature;
import org.apache.uima.ruta.expression.feature.SimpleFeatureExpression;
import org.apache.uima.ruta.expression.feature.TypeFeature;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class FeatureMatchExpression
extends SimpleFeatureExpression {
    public static final String EQUAL = "==";
    public static final String NOT_EQUAL = "!=";
    private IRutaExpression arg;
    private String op;

    public FeatureMatchExpression(MatchReference mr, String op, IRutaExpression arg) {
        super(mr);
        this.op = op;
        this.arg = arg;
    }

    public IRutaExpression getArg() {
        return this.arg;
    }

    public void setArg(RutaExpression arg) {
        this.arg = arg;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public boolean checkFeatureValue(FeatureStructure fs, MatchContext context, RutaStream stream) {
        Feature feature = this.getFeature(context, stream);
        if (feature instanceof LazyFeature) {
            LazyFeature lazyFeature = (LazyFeature)feature;
            feature = lazyFeature.initialize(fs);
        }
        return this.checkFeatureValue(fs, feature, context, stream);
    }

    public boolean checkFeatureValue(FeatureStructure fs, Feature feature, MatchContext context, RutaStream stream) {
        String rangeName;
        Type featureRangeType = null;
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        if (feature instanceof TypeFeature) {
            if (this.getArg() instanceof ITypeExpression) {
                Type t1 = fs.getType();
                ITypeExpression expr = (ITypeExpression)this.getArg();
                Type t2 = expr.getType(context, stream);
                return this.compare(t1, t2);
            }
        } else if (feature instanceof CoveredTextFeature) {
            featureRangeType = typeSystem.getType("uima.cas.String");
        } else if (feature != null) {
            featureRangeType = feature.getRange();
        }
        if ((rangeName = featureRangeType.getName()).equals("uima.cas.Boolean")) {
            Boolean v1 = fs.getBooleanValue(feature);
            if (this.getArg() instanceof IBooleanExpression) {
                IBooleanExpression expr = (IBooleanExpression)this.getArg();
                Boolean v2 = expr.getBooleanValue(context, stream);
                return this.compare(v1, v2);
            }
        } else if (rangeName.equals("uima.cas.Integer") || rangeName.equals("uima.cas.Byte") || rangeName.equals("uima.cas.Short") || rangeName.equals("uima.cas.Long")) {
            Integer v1 = fs.getIntValue(feature);
            if (this.getArg() instanceof INumberExpression) {
                INumberExpression expr = (INumberExpression)this.getArg();
                Integer v2 = expr.getIntegerValue(context, stream);
                return this.compare(v1, v2);
            }
        } else if (rangeName.equals("uima.cas.Double")) {
            Double v1 = fs.getDoubleValue(feature);
            if (this.getArg() instanceof INumberExpression) {
                INumberExpression expr = (INumberExpression)this.getArg();
                Double v2 = expr.getDoubleValue(context, stream);
                return this.compare(v1, v2);
            }
        } else if (rangeName.equals("uima.cas.Float")) {
            Float v1 = Float.valueOf(fs.getFloatValue(feature));
            if (this.getArg() instanceof INumberExpression) {
                INumberExpression expr = (INumberExpression)this.getArg();
                Float v2 = Float.valueOf(expr.getFloatValue(context, stream));
                return this.compare(v1, v2);
            }
        } else if (typeSystem.subsumes(typeSystem.getType("uima.cas.String"), featureRangeType)) {
            String v1 = null;
            if (feature instanceof CoveredTextFeature && fs instanceof AnnotationFS) {
                v1 = ((AnnotationFS)fs).getCoveredText();
            } else if (feature != null) {
                v1 = fs.getStringValue(feature);
            }
            if (this.getArg() instanceof IStringExpression) {
                IStringExpression expr = (IStringExpression)this.getArg();
                String v2 = expr.getStringValue(context, stream);
                return this.compare(v1, v2);
            }
        } else {
            FeatureStructure featureValue = fs.getFeatureValue(feature);
            if (!feature.getRange().isPrimitive() && this.getArg() instanceof FeatureExpression) {
                FeatureExpression fe = (FeatureExpression)this.getArg();
                Collection<? extends FeatureStructure> featureAnnotations = fe.getFeatureStructures(Arrays.asList(fs), false, context, stream);
                return this.compare(featureValue, featureAnnotations);
            }
            if (!feature.getRange().isPrimitive() && this.getArg() instanceof IAnnotationExpression) {
                IAnnotationExpression ae = (IAnnotationExpression)this.getArg();
                AnnotationFS compareAnnotation = ae.getAnnotation(context, stream);
                return this.compare(featureValue, compareAnnotation);
            }
            if (!feature.getRange().isPrimitive() && typeSystem.subsumes(typeSystem.getType("uima.cas.FSArray"), featureRangeType) && this.getArg() instanceof IAnnotationListExpression) {
                ArrayFS fsArray = (ArrayFS)featureValue;
                IAnnotationListExpression ale = (IAnnotationListExpression)this.getArg();
                List<AnnotationFS> annotationList = ale.getAnnotationList(context, stream);
                return this.compare(Arrays.asList(fsArray.toArray()), annotationList);
            }
        }
        return false;
    }

    private boolean compare(Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            if (v1 == null && v2 == null) {
                if (this.getOp().equals(EQUAL)) {
                    return true;
                }
                if (this.getOp().equals(NOT_EQUAL)) {
                    return false;
                }
            } else {
                if (this.getOp().equals(EQUAL)) {
                    return false;
                }
                if (this.getOp().equals(NOT_EQUAL)) {
                    return true;
                }
            }
        } else if (v1 instanceof Number && v2 instanceof Number) {
            Number n1 = (Number)v1;
            Number n2 = (Number)v2;
            int compareTo = 0;
            try {
                compareTo = new BigDecimal(n1.toString()).compareTo(new BigDecimal(n2.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getOp().equals(EQUAL)) {
                return compareTo == 0;
            }
            if (this.getOp().equals(NOT_EQUAL)) {
                return compareTo != 0;
            }
            if (this.getOp().equals(">=")) {
                return compareTo >= 0;
            }
            if (this.getOp().equals(">")) {
                return compareTo > 0;
            }
            if (this.getOp().equals("<=")) {
                return compareTo <= 0;
            }
            if (this.getOp().equals("<")) {
                return compareTo < 0;
            }
        } else if (v1 != null && v2 != null) {
            if (this.getOp().equals(EQUAL)) {
                return v1.equals(v2);
            }
            if (this.getOp().equals(NOT_EQUAL)) {
                return !v1.equals(v2);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        Object result = super.toString();
        if (this.op != null) {
            result = (String)result + this.op;
        }
        if (this.arg != null) {
            result = (String)result + this.arg.toString();
        }
        return result;
    }
}

