/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractMarkAction;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaAnnotation;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MarkAction
extends AbstractMarkAction {
    protected final INumberExpression score;
    protected final List<INumberExpression> list;

    public MarkAction(ITypeExpression type, INumberExpression scoreValue, List<INumberExpression> list) {
        super(type);
        this.score = scoreValue;
        this.list = list;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        List<Integer> indexList = this.getIndexList(context, this.list, stream);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(indexList, element.getContainer());
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            if (matchedAnnotation == null) {
                return;
            }
            if (this.score == null) {
                this.createAnnotation(matchedAnnotation, context, stream);
                continue;
            }
            double deltaScore = this.score.getDoubleValue(context, stream);
            this.updateHeuristicAnnotation(context, stream, matchedAnnotation, deltaScore);
        }
    }

    protected void updateHeuristicAnnotation(MatchContext context, RutaStream stream, AnnotationFS matchedAnnotation, double deltaScore) {
        Annotation targetAnnotation = null;
        Type t = this.type.getType(context, stream);
        if (t == null) {
            return;
        }
        List annotationsInSpan = CasUtil.selectAt((CAS)stream.getCas(), (Type)t, (int)matchedAnnotation.getBegin(), (int)matchedAnnotation.getEnd());
        targetAnnotation = annotationsInSpan.isEmpty() ? this.createAnnotation(matchedAnnotation, context, stream) : (Annotation)annotationsInSpan.get(0);
        if (targetAnnotation == null) {
            return;
        }
        RutaAnnotation rutaAnnotation = stream.getRutaAnnotationFor((AnnotationFS)targetAnnotation, true, stream);
        stream.removeAnnotation((AnnotationFS)rutaAnnotation);
        double newScore = rutaAnnotation.getScore() + deltaScore;
        rutaAnnotation.setScore(newScore);
        rutaAnnotation.addToIndexes();
        stream.addAnnotation((AnnotationFS)rutaAnnotation, context.getRuleMatch());
    }

    public INumberExpression getScore() {
        return this.score;
    }

    public List<INumberExpression> getList() {
        return this.list;
    }
}

