/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.application.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;

public class UimaXmlParsingUtil {
    public static XMLizable parseUimaXmlDescriptor(String xmlDescriptorFileName) throws IOException, InvalidXMLException {
        boolean validArgs;
        XMLizable descriptionObject = null;
        File descFile = new File(xmlDescriptorFileName);
        boolean bl = validArgs = descFile.exists() && !descFile.isDirectory();
        if (!validArgs) {
            Trace.err("Cannot find: " + xmlDescriptorFileName);
            return null;
        }
        UIMAFramework.getLogger().setOutputStream(new PrintStream(new FileOutputStream("uima.log")));
        XMLInputSource in = new XMLInputSource(descFile);
        descriptionObject = UIMAFramework.getXMLParser().parse(in);
        return descriptionObject;
    }

    public static XMLizable parseUimaXmlDescriptorFromString(String xmlDescriptorString) {
        XMLizable descriptionObject = null;
        try {
            UIMAFramework.getLogger().setOutputStream(new PrintStream(new FileOutputStream("uima.log")));
            XMLInputSource in = new XMLInputSource((InputStream)new ByteArrayInputStream(xmlDescriptorString.getBytes()), null);
            descriptionObject = UIMAFramework.getXMLParser().parse(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidXMLException e) {
            Trace.err("xmlDescriptorString: " + xmlDescriptorString);
            e.printStackTrace();
            return null;
        }
        catch (UIMA_IllegalStateException e) {
            Trace.err("xmlDescriptorString: " + xmlDescriptorString);
            return null;
        }
        return descriptionObject;
    }
}

